"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundRoute = NotFoundRoute;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let bannerId;
function NotFoundRoute() {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    urlForwarding,
    urlTracker,
    core,
    history
  } = services;
  const currentLocation = history.location.pathname;
  (0, _react.useEffect)(() => {
    const path = window.location.hash.substr(1);
    urlTracker.restorePreviousUrl();
    urlForwarding.navigateToLegacyKibanaUrl(path);
    const bannerMessage = _i18n.i18n.translate('discover.noMatchRoute.bannerTitleText', {
      defaultMessage: 'Page not found'
    });
    bannerId = core.overlays.banners.replace(bannerId, (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "iInCircle",
      title: bannerMessage
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "invalidRouteMessage"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noMatchRoute.bannerText",
      defaultMessage: "Discover application doesn't recognize this route: {route}",
      values: {
        route: history.location.state.referrer
      }
    }))), {
      theme: core.theme,
      i18n: core.i18n
    }));

    // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
    setTimeout(() => {
      if (bannerId) {
        core.overlays.banners.remove(bannerId);
      }
    }, 15000);
  }, [core, history, urlForwarding, urlTracker]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: '/',
      state: {
        referrer: currentLocation
      }
    }
  });
}