"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedSearchInitial = exports.useSavedSearchHasChanged = exports.useSavedSearch = exports.DiscoverStateProvider = exports.DiscoverMainProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _discover_internal_state_container = require("./discover_internal_state_container");
var _discover_app_state_container = require("./discover_app_state_container");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createStateHelpers() {
  const context = /*#__PURE__*/_react.default.createContext(null);
  const useContainer = () => (0, _react.useContext)(context);
  const useSavedSearch = () => {
    const container = useContainer();
    return (0, _useObservable.default)(container.savedSearchState.getCurrent$(), container.savedSearchState.getCurrent$().getValue());
  };
  const useSavedSearchInitial = () => {
    const container = useContainer();
    return (0, _useObservable.default)(container.savedSearchState.getInitial$(), container.savedSearchState.getInitial$().getValue());
  };
  const useSavedSearchHasChanged = () => {
    const container = useContainer();
    return (0, _useObservable.default)(container.savedSearchState.getHasChanged$(), container.savedSearchState.getHasChanged$().getValue());
  };
  return {
    Provider: context.Provider,
    useSavedSearch,
    useSavedSearchInitial,
    useSavedSearchHasChanged
  };
}
const {
  Provider: DiscoverStateProvider,
  useSavedSearchInitial,
  useSavedSearch,
  useSavedSearchHasChanged
} = createStateHelpers();
exports.useSavedSearchHasChanged = useSavedSearchHasChanged;
exports.useSavedSearch = useSavedSearch;
exports.useSavedSearchInitial = useSavedSearchInitial;
exports.DiscoverStateProvider = DiscoverStateProvider;
const DiscoverMainProvider = ({
  value,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(DiscoverStateProvider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(_discover_app_state_container.DiscoverAppStateProvider, {
    value: value.appState
  }, /*#__PURE__*/_react.default.createElement(_discover_internal_state_container.InternalStateProvider, {
    value: value.internalState
  }, children)));
};
exports.DiscoverMainProvider = DiscoverMainProvider;