"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changeDataView = changeDataView;
var _discoverUtils = require("@kbn/discover-utils");
var _add_log = require("../../../../utils/add_log");
var _get_switch_data_view_app_state = require("../../utils/get_switch_data_view_app_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Function executed when switching data view in the UI
 */
async function changeDataView(id, {
  services,
  internalState,
  appState
}) {
  (0, _add_log.addLog)('[ui] changeDataView', {
    id
  });
  const {
    dataViews,
    uiSettings
  } = services;
  const dataView = internalState.getState().dataView;
  const state = appState.getState();
  let nextDataView = null;
  internalState.transitions.setIsDataViewLoading(true);
  try {
    nextDataView = typeof id === 'string' ? await dataViews.get(id, false) : id;
  } catch (e) {
    //
  }
  if (nextDataView && dataView) {
    const nextAppState = (0, _get_switch_data_view_app_state.getDataViewAppState)(dataView, nextDataView, uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING, []), state.columns || [], state.sort || [], uiSettings.get(_discoverUtils.MODIFY_COLUMNS_ON_SWITCH), uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING), state.query);
    appState.update(nextAppState);
    if (internalState.getState().expandedDoc) {
      internalState.transitions.setExpandedDoc(undefined);
    }
  }
  internalState.transitions.setIsDataViewLoading(false);
}