"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainRoute = DiscoverMainRoute;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/saved-search-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _ebtTools = require("@kbn/ebt-tools");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _dataViewUtils = require("@kbn/data-view-utils");
var _use_url = require("./hooks/use_url");
var _use_discover_state_container = require("./hooks/use_discover_state_container");
var _discover_main_app = require("./discover_main_app");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _loading_indicator = require("../../components/common/loading_indicator");
var _error_alert = require("../../components/common/error_alert");
var _use_discover_services = require("../../hooks/use_discover_services");
var _use_alert_results_toast = require("./hooks/use_alert_results_toast");
var _discover_state_provider = require("./services/discover_state_provider");
var _customizations = require("../../customizations");
var _discover_topnav_inline = require("./components/top_nav/discover_topnav_inline");
var _is_text_based_query = require("./utils/is_text_based_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const DiscoverMainAppMemoized = /*#__PURE__*/(0, _react.memo)(_discover_main_app.DiscoverMainApp);
function DiscoverMainRoute({
  customizationCallbacks,
  customizationContext,
  stateStorageContainer
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    core,
    chrome,
    data,
    toastNotifications,
    http: {
      basePath
    },
    dataViewEditor,
    share,
    getScopedHistory
  } = services;
  const {
    id: savedSearchId
  } = (0, _reactRouterDom.useParams)();
  const [stateContainer, {
    reset: resetStateContainer
  }] = (0, _use_discover_state_container.useDiscoverStateContainer)({
    history,
    services,
    customizationContext,
    stateStorageContainer
  });
  const {
    customizationService,
    isInitialized: isCustomizationServiceInitialized
  } = (0, _customizations.useDiscoverCustomizationService)({
    customizationCallbacks,
    stateContainer
  });
  const [error, setError] = (0, _react.useState)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const [hasESData, setHasESData] = (0, _react.useState)(false);
  const [hasUserDataView, setHasUserDataView] = (0, _react.useState)(false);
  const [showNoDataPage, setShowNoDataPage] = (0, _react.useState)(false);
  const hasCustomBranding = (0, _useObservable.default)(core.customBranding.hasCustomBranding$, false);

  /**
   * Get location state of scoped history only on initial load
   */
  const historyLocationState = (0, _react.useMemo)(() => {
    var _getScopedHistory;
    return (_getScopedHistory = getScopedHistory()) === null || _getScopedHistory === void 0 ? void 0 : _getScopedHistory.location.state;
  }, [getScopedHistory]);
  (0, _use_alert_results_toast.useAlertResultsToast)({
    isAlertResults: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.isAlertResults,
    toastNotifications
  });
  (0, _public2.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'app',
    id: savedSearchId || 'new'
  });
  const checkData = (0, _react.useCallback)(async () => {
    try {
      if (savedSearchId) {
        return true; // bypass NoData screen
      }
      if ((0, _esQuery.isOfEsqlQueryType)(stateContainer.appState.getState().query)) {
        return true;
      }
      const hasUserDataViewValue = await data.dataViews.hasData.hasUserDataView().catch(() => false);
      const hasESDataValue = await data.dataViews.hasData.hasESData().catch(() => false);
      setHasUserDataView(hasUserDataViewValue);
      setHasESData(hasESDataValue);
      if (!hasUserDataViewValue) {
        setShowNoDataPage(true);
        return false;
      }
      let defaultDataViewExists = false;
      try {
        defaultDataViewExists = await data.dataViews.defaultDataViewExists();
      } catch (e) {
        //
      }
      if (!defaultDataViewExists) {
        setShowNoDataPage(true);
        return false;
      }
      return true;
    } catch (e) {
      setError(e);
      return false;
    }
  }, [data.dataViews, savedSearchId, stateContainer.appState]);
  const loadSavedSearch = (0, _react.useCallback)(async ({
    nextDataView,
    initialAppState
  } = {}) => {
    const loadSavedSearchStartTime = window.performance.now();
    setLoading(true);
    if (!nextDataView && !(await checkData())) {
      setLoading(false);
      return;
    }
    try {
      await stateContainer.actions.loadDataViewList();
      const currentSavedSearch = await stateContainer.actions.loadSavedSearch({
        savedSearchId,
        dataView: nextDataView,
        dataViewSpec: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec,
        initialAppState
      });
      if (customizationContext.displayMode === 'standalone') {
        var _currentSavedSearch$t2;
        if (currentSavedSearch !== null && currentSavedSearch !== void 0 && currentSavedSearch.id) {
          var _currentSavedSearch$t;
          chrome.recentlyAccessed.add((0, _public3.getSavedSearchFullPathUrl)(currentSavedSearch.id), (_currentSavedSearch$t = currentSavedSearch.title) !== null && _currentSavedSearch$t !== void 0 ? _currentSavedSearch$t : '', currentSavedSearch.id);
        }
        (0, _breadcrumbs.setBreadcrumbs)({
          services,
          titleBreadcrumbText: (_currentSavedSearch$t2 = currentSavedSearch === null || currentSavedSearch === void 0 ? void 0 : currentSavedSearch.title) !== null && _currentSavedSearch$t2 !== void 0 ? _currentSavedSearch$t2 : undefined
        });
      }
      setLoading(false);
      if (services.analytics) {
        const loadSavedSearchDuration = window.performance.now() - loadSavedSearchStartTime;
        (0, _ebtTools.reportPerformanceMetricEvent)(services.analytics, {
          eventName: 'discoverLoadSavedSearch',
          duration: loadSavedSearchDuration
        });
      }
    } catch (e) {
      if (e instanceof _public.SavedObjectNotFound) {
        (0, _public.redirectWhenMissing)({
          history,
          navigateToApp: core.application.navigateToApp,
          basePath,
          mapping: {
            search: '/',
            'index-pattern': {
              app: 'management',
              path: `kibana/objects/savedSearches/${savedSearchId}`
            }
          },
          toastNotifications,
          onBeforeRedirect() {
            services.urlTracker.setTrackedUrl('/');
          },
          theme: core.theme
        })(e);
      } else {
        setError(e);
      }
    }
  }, [checkData, stateContainer.actions, savedSearchId, historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec, customizationContext.displayMode, services, chrome.recentlyAccessed, history, core.application.navigateToApp, core.theme, basePath, toastNotifications]);
  (0, _react.useEffect)(() => {
    if (!isCustomizationServiceInitialized) return;
    setLoading(true);
    setHasESData(false);
    setHasUserDataView(false);
    setShowNoDataPage(false);
    setError(undefined);
    if (savedSearchId) {
      loadSavedSearch();
    } else {
      // restore the previously selected data view for a new state (when a saved search was open)
      loadSavedSearch(getLoadParamsForNewSearch(stateContainer));
    }
  }, [isCustomizationServiceInitialized, loadSavedSearch, savedSearchId, stateContainer]);

  // secondary fetch: in case URL is set to `/`, used to reset to 'new' state, keeping the current data view
  (0, _use_url.useUrl)({
    history,
    savedSearchId,
    onNewUrl: () => {
      // restore the previously selected data view for a new state
      loadSavedSearch(getLoadParamsForNewSearch(stateContainer));
    }
  });
  const onDataViewCreated = (0, _react.useCallback)(async nextDataView => {
    if (nextDataView) {
      setLoading(true);
      setShowNoDataPage(false);
      setError(undefined);
      await loadSavedSearch({
        nextDataView: nextDataView
      });
    }
  }, [loadSavedSearch]);
  const onESQLNavigationComplete = (0, _react.useCallback)(async () => {
    resetStateContainer();
  }, [resetStateContainer]);
  const noDataDependencies = (0, _react.useMemo)(() => ({
    coreStart: core,
    dataViews: {
      ...data.dataViews,
      hasData: {
        ...data.dataViews.hasData,
        // We've already called this, so we can optimize the analytics services to
        // use the already-retrieved data to avoid a double-call.
        hasESData: () => Promise.resolve(hasESData),
        hasUserDataView: () => Promise.resolve(hasUserDataView)
      }
    },
    share,
    dataViewEditor,
    noDataPage: services.noDataPage
  }), [core, data.dataViews, dataViewEditor, hasESData, hasUserDataView, services.noDataPage, share]);
  const loadingIndicator = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
    type: hasCustomBranding ? 'spinner' : 'elastic'
  }), [hasCustomBranding]);
  const mainContent = (0, _react.useMemo)(() => {
    if (showNoDataPage) {
      const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
      const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/_react.default.lazy(() => importPromise.then(({
        AnalyticsNoDataPageKibanaProvider: NoDataProvider
      }) => {
        return {
          default: NoDataProvider
        };
      })));
      const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/_react.default.lazy(() => importPromise.then(({
        AnalyticsNoDataPage: NoDataPage
      }) => {
        return {
          default: NoDataPage
        };
      })));
      return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, noDataDependencies, /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
        onDataViewCreated: onDataViewCreated,
        onESQLNavigationComplete: onESQLNavigationComplete
      }));
    }
    if (loading) {
      return loadingIndicator;
    }
    return /*#__PURE__*/_react.default.createElement(DiscoverMainAppMemoized, {
      stateContainer: stateContainer
    });
  }, [loading, loadingIndicator, noDataDependencies, onDataViewCreated, onESQLNavigationComplete, showNoDataPage, stateContainer]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: error
    });
  }
  if (!customizationService) {
    return loadingIndicator;
  }
  return /*#__PURE__*/_react.default.createElement(_customizations.DiscoverCustomizationProvider, {
    value: customizationService
  }, /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: stateContainer
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_discover_topnav_inline.DiscoverTopNavInline, {
    stateContainer: stateContainer,
    hideNavMenuItems: loading
  }), mainContent)));
}
// eslint-disable-next-line import/no-default-export
var _default = exports.default = DiscoverMainRoute;
function getLoadParamsForNewSearch(stateContainer) {
  const prevAppState = stateContainer.appState.getState();
  const prevDataView = stateContainer.internalState.getState().dataView;
  const initialAppState = prevAppState !== null && prevAppState !== void 0 && prevAppState.query && (0, _is_text_based_query.isTextBasedQuery)(prevAppState.query) && prevDataView && prevDataView.type === _dataViewUtils.ESQL_TYPE ? {
    // reset to a default ES|QL query
    query: {
      esql: (0, _esqlUtils.getInitialESQLQuery)(prevDataView.getIndexPattern())
    }
  } : undefined;
  return {
    nextDataView: prevDataView,
    initialAppState
  };
}