"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverTopNav = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _customizations = require("../../../../customizations");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _use_inspector = require("../../hooks/use_inspector");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
var _is_text_based_query = require("../../utils/is_text_based_query");
var _get_top_nav_badges = require("./get_top_nav_badges");
var _get_top_nav_links = require("./get_top_nav_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDiscoverTopNav = ({
  stateContainer
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const topNavCustomization = (0, _customizations.useDiscoverCustomization)('top_nav');
  const hasSavedSearchChanges = (0, _useObservable.default)(stateContainer.savedSearchState.getHasChanged$());
  const hasUnsavedChanges = Boolean(hasSavedSearchChanges && stateContainer.savedSearchState.getId());
  const topNavBadges = (0, _react.useMemo)(() => (0, _get_top_nav_badges.getTopNavBadges)({
    stateContainer,
    services,
    hasUnsavedChanges,
    topNavCustomization
  }), [stateContainer, services, hasUnsavedChanges, topNavCustomization]);
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const adHocDataViews = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.adHocDataViews);
  const query = (0, _discover_app_state_container.useAppStateSelector)(state => state.query);
  const isTextBased = (0, _react.useMemo)(() => (0, _is_text_based_query.isTextBasedQuery)(query), [query]);
  const onOpenInspector = (0, _use_inspector.useInspector)({
    inspector: services.inspector,
    stateContainer
  });
  const topNavMenu = (0, _react.useMemo)(() => (0, _get_top_nav_links.getTopNavLinks)({
    dataView,
    services,
    state: stateContainer,
    onOpenInspector,
    isTextBased,
    adHocDataViews,
    topNavCustomization
  }), [adHocDataViews, dataView, isTextBased, onOpenInspector, services, stateContainer, topNavCustomization]);
  return {
    topNavMenu,
    topNavBadges
  };
};
exports.useDiscoverTopNav = useDiscoverTopNav;