"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTopNavInline = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/navigation-plugin/public");
var _uiTheme = require("@kbn/ui-theme");
var _logs_explorer_tabs = require("../../../../components/logs_explorer_tabs");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _use_discover_topnav = require("./use_discover_topnav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverTopNavInline = ({
  stateContainer,
  hideNavMenuItems
}) => {
  const {
    customizationContext
  } = stateContainer;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    topNavBadges,
    topNavMenu
  } = (0, _use_discover_topnav.useDiscoverTopNav)({
    stateContainer
  });
  if (!customizationContext.inlineTopNav.enabled || customizationContext.displayMode !== 'standalone') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, {
    css: {
      boxShadow: 'none',
      backgroundColor: _uiTheme.euiThemeVars.euiPageBackgroundColor
    },
    "data-test-subj": "discoverTopNavInline"
  }, customizationContext.inlineTopNav.showLogsExplorerTabs && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_logs_explorer_tabs.LogsExplorerTabs, {
    services: services,
    selectedTab: "discover"
  }))), !hideNavMenuItems && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    side: "right",
    "data-test-subj": "topNavMenuItems"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_public.TopNavMenuBadges, {
    badges: topNavBadges
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_public.TopNavMenuItems, {
    config: topNavMenu
  }))));
};
exports.DiscoverTopNavInline = DiscoverTopNavInline;