"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedVSAvailableCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SelectedVSAvailableCallout = ({
  isPlainRecord,
  textBasedQueryColumns,
  selectedColumns
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPlainRecord && textBasedQueryColumns && selectedColumns.length > 0 && selectedColumns.length < textBasedQueryColumns.length && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    "data-test-subj": "dscSelectedColumnsCallout",
    iconType: "iInCircle",
    title: _i18n.i18n.translate('discover.textBasedMode.selectedColumnsCallout', {
      defaultMessage: 'Displaying {selectedColumnsNumber} of {textBasedQueryColumnsNumber} fields. Add more from the Available fields list.',
      values: {
        textBasedQueryColumnsNumber: textBasedQueryColumns.length,
        selectedColumnsNumber: selectedColumns.length
      }
    }),
    size: "s"
  }));
};
exports.SelectedVSAvailableCallout = SelectedVSAvailableCallout;