"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainContent = void 0;
var _eui = require("@elastic/eui");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _view_mode_toggle = require("../../../../components/view_mode_toggle");
var _field_stats_table = require("../field_stats_table");
var _discover_documents = require("./discover_documents");
var _constants2 = require("../field_stats_table/constants");
var _discover_app_state_container = require("../../services/discover_app_state_container");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DROP_PROPS = {
  value: {
    id: 'dscDropZoneTable',
    humanData: {
      label: _i18n.i18n.translate('discover.dropZoneTableLabel', {
        defaultMessage: 'Drop zone to add field as a column to the table'
      })
    }
  },
  order: [1, 0, 0, 0],
  types: ['field_add']
};
const DiscoverMainContent = ({
  dataView,
  isPlainRecord,
  viewMode,
  onAddFilter,
  onFieldEdited,
  columns,
  stateContainer,
  onDropFieldToTable,
  panelsToggle,
  isChartAvailable
}) => {
  const {
    trackUiMetric
  } = (0, _use_discover_services.useDiscoverServices)();
  const setDiscoverViewMode = (0, _react.useCallback)(mode => {
    stateContainer.appState.update({
      viewMode: mode
    });
    if (trackUiMetric) {
      if (mode === _constants.VIEW_MODE.AGGREGATED_LEVEL) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants2.FIELD_STATISTICS_VIEW_CLICK);
      } else {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants2.DOCUMENTS_VIEW_CLICK);
      }
    }
  }, [trackUiMetric, stateContainer]);
  const isDropAllowed = Boolean(onDropFieldToTable);
  const viewModeToggle = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_view_mode_toggle.DocumentViewModeToggle, {
      viewMode: viewMode,
      isTextBasedQuery: isPlainRecord,
      stateContainer: stateContainer,
      setDiscoverViewMode: setDiscoverViewMode,
      prepend: /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
        renderedFor: 'tabs',
        isChartAvailable
      }) : undefined
    });
  }, [viewMode, setDiscoverViewMode, isPlainRecord, stateContainer, panelsToggle, isChartAvailable]);
  const showChart = (0, _discover_app_state_container.useAppStateSelector)(state => !state.hideChart);
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.Droppable, {
    dropTypes: isDropAllowed ? DROP_PROPS.types : undefined,
    value: DROP_PROPS.value,
    order: DROP_PROPS.order,
    onDrop: onDropFieldToTable
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.DropOverlayWrapper, {
    isVisible: isDropAllowed
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-fullHeight",
    direction: "column",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "dscMainContent"
  }, showChart && isChartAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL ? /*#__PURE__*/_react.default.createElement(_discover_documents.DiscoverDocuments, {
    viewModeToggle: viewModeToggle,
    dataView: dataView,
    onAddFilter: !isPlainRecord ? onAddFilter : undefined,
    stateContainer: stateContainer,
    onFieldEdited: !isPlainRecord ? onFieldEdited : undefined
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, viewModeToggle), /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTab, {
    dataView: dataView,
    columns: columns,
    stateContainer: stateContainer,
    onAddFilter: !isPlainRecord ? onAddFilter : undefined,
    trackUiMetric: trackUiMetric
  })))));
};
exports.DiscoverMainContent = DiscoverMainContent;