"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverHistogramLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-histogram-plugin/public");
var _react2 = require("@emotion/react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_discover_histogram = require("./use_discover_histogram");
var _discover_main_content = require("./discover_main_content");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _types = require("../../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const histogramLayoutCss = (0, _react2.css)`
  height: 100%;
`;
const DiscoverHistogramLayout = ({
  isPlainRecord,
  dataView,
  stateContainer,
  container,
  panelsToggle,
  ...mainContentProps
}) => {
  const {
    dataState
  } = stateContainer;
  const searchSessionId = (0, _useObservable.default)(stateContainer.searchSessionManager.searchSessionId$);
  const hideChart = (0, _discover_app_state_container.useAppStateSelector)(state => state.hideChart);
  const unifiedHistogramProps = (0, _use_discover_histogram.useDiscoverHistogram)({
    stateContainer,
    inspectorAdapters: dataState.inspectorAdapters,
    hideChart,
    isPlainRecord
  });
  const datatable = (0, _useObservable.default)(dataState.data$.documents$);
  const renderCustomChartToggleActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
    renderedFor: 'histogram'
  }) : panelsToggle, [panelsToggle]);
  const table = (0, _react.useMemo)(() => {
    if (isPlainRecord && datatable && [_types.FetchStatus.PARTIAL, _types.FetchStatus.COMPLETE].includes(datatable.fetchStatus)) {
      return {
        type: 'datatable',
        rows: datatable.result.map(r => r.raw),
        columns: datatable.textBasedQueryColumns || []
      };
    }
  }, [datatable, isPlainRecord]);

  // Initialized when the first search has been requested or
  // when in text-based mode since search sessions are not supported
  if (!searchSessionId && !isPlainRecord) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_public.UnifiedHistogramContainer, (0, _extends2.default)({}, unifiedHistogramProps, {
    searchSessionId: searchSessionId,
    requestAdapter: dataState.inspectorAdapters.requests,
    table: table,
    container: container,
    css: histogramLayoutCss,
    renderCustomChartToggleActions: renderCustomChartToggleActions,
    abortController: stateContainer.dataState.getAbortController()
  }), /*#__PURE__*/_react.default.createElement(_discover_main_content.DiscoverMainContent, (0, _extends2.default)({}, mainContentProps, {
    stateContainer: stateContainer,
    dataView: dataView,
    isPlainRecord: isPlainRecord,
    panelsToggle: panelsToggle
  })));
};
exports.DiscoverHistogramLayout = DiscoverHistogramLayout;