"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverRoutes = exports.DiscoverRouter = exports.CustomDiscoverRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _context = require("./context");
var _doc = require("./doc");
var _main = require("./main");
var _not_found = require("./not_found");
var _view_alert = require("./view_alert");
var _customizations = require("../../common/customizations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverRoutes = ({
  prefix,
  ...mainRouteProps
}) => {
  const prefixPath = (0, _react.useCallback)(path => prefix ? `${prefix}/${path}` : `/${path}`, [prefix]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: prefixPath('context/:dataViewId/:id')
  }, /*#__PURE__*/_react.default.createElement(_context.ContextAppRoute, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: prefixPath('doc/:dataView/:index/:type'),
    render: props => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: prefixPath(`doc/${props.match.params.dataView}/${props.match.params.index}`)
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: prefixPath('doc/:dataViewId/:index')
  }, /*#__PURE__*/_react.default.createElement(_doc.SingleDocRoute, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: prefixPath('viewAlert/:id')
  }, /*#__PURE__*/_react.default.createElement(_view_alert.ViewAlertRoute, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: prefixPath('view/:id')
  }, /*#__PURE__*/_react.default.createElement(_main.DiscoverMainRoute, mainRouteProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: prefixPath(''),
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_main.DiscoverMainRoute, mainRouteProps)), /*#__PURE__*/_react.default.createElement(_not_found.NotFoundRoute, null));
};
exports.DiscoverRoutes = DiscoverRoutes;
const CustomDiscoverRoutes = ({
  profileRegistry,
  ...props
}) => {
  const {
    profile
  } = (0, _reactRouterDom.useParams)();
  const customizationCallbacks = (0, _react.useMemo)(() => {
    var _profileRegistry$get;
    return (_profileRegistry$get = profileRegistry.get(profile)) === null || _profileRegistry$get === void 0 ? void 0 : _profileRegistry$get.customizationCallbacks;
  }, [profile, profileRegistry]);
  if (customizationCallbacks) {
    return /*#__PURE__*/_react.default.createElement(DiscoverRoutes, (0, _extends2.default)({
      prefix: (0, _customizations.addProfile)('', profile),
      customizationCallbacks: customizationCallbacks
    }, props));
  }
  return /*#__PURE__*/_react.default.createElement(_not_found.NotFoundRoute, null);
};
exports.CustomDiscoverRoutes = CustomDiscoverRoutes;
const DiscoverRouter = ({
  services,
  history,
  profileRegistry,
  ...routeProps
}) => {
  const customizationCallbacks = (0, _react.useMemo)(() => {
    var _profileRegistry$get$, _profileRegistry$get2;
    return (_profileRegistry$get$ = (_profileRegistry$get2 = profileRegistry.get('default')) === null || _profileRegistry$get2 === void 0 ? void 0 : _profileRegistry$get2.customizationCallbacks) !== null && _profileRegistry$get$ !== void 0 ? _profileRegistry$get$ : [];
  }, [profileRegistry]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    "data-test-subj": "discover-react-router"
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _customizations.addProfile)('', ':profile')
  }, /*#__PURE__*/_react.default.createElement(CustomDiscoverRoutes, (0, _extends2.default)({
    profileRegistry: profileRegistry
  }, routeProps))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(DiscoverRoutes, (0, _extends2.default)({
    customizationCallbacks: customizationCallbacks
  }, routeProps)))))));
};
exports.DiscoverRouter = DiscoverRouter;