"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextApp = void 0;
var _react = _interopRequireWildcard(require("react"));
require("./context_app.scss");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _i18n = require("@kbn/i18n");
var _ebtTools = require("@kbn/ebt-tools");
var _discoverUtils = require("@kbn/discover-utils");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _context_error_message = require("./components/context_error_message");
var _context_query_state = require("./services/context_query_state");
var _context_state = require("./services/context_state");
var _use_context_app_state = require("./hooks/use_context_app_state");
var _use_context_app_fetch = require("./hooks/use_context_app_fetch");
var _context_app_content = require("./context_app_content");
var _context = require("./services/context");
var _use_discover_services = require("../../hooks/use_discover_services");
var _breadcrumbs = require("../../utils/breadcrumbs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ContextAppContentMemoized = /*#__PURE__*/(0, _react.memo)(_context_app_content.ContextAppContent);
const ContextApp = ({
  dataView,
  anchorId,
  referrer
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    analytics,
    locator,
    uiSettings,
    capabilities,
    dataViews,
    navigation,
    filterManager,
    core
  } = services;
  const isLegacy = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.DOC_TABLE_LEGACY), [uiSettings]);
  const useNewFieldsApi = (0, _react.useMemo)(() => !uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE), [uiSettings]);

  /**
   * Context app state
   */
  const {
    appState,
    globalState,
    stateContainer
  } = (0, _use_context_app_state.useContextAppState)({
    services,
    dataView
  });
  const prevAppState = (0, _react.useRef)();
  const prevGlobalState = (0, _react.useRef)({
    filters: []
  });
  const {
    columns,
    onAddColumn,
    onRemoveColumn,
    onSetColumns
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    useNewFieldsApi,
    setAppState: stateContainer.setAppState,
    columns: appState.columns,
    sort: appState.sort
  });
  (0, _react.useEffect)(() => {
    (0, _breadcrumbs.setBreadcrumbs)({
      services,
      rootBreadcrumbPath: referrer,
      titleBreadcrumbText: _i18n.i18n.translate('discover.context.breadcrumb', {
        defaultMessage: 'Surrounding documents'
      })
    });
  }, [locator, referrer, services]);
  (0, _public.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'context',
    id: dataView.id || ''
  });

  /**
   * Context fetched state
   */
  const {
    fetchedState,
    fetchContextRows,
    fetchAllRows,
    fetchSurroundingRows,
    resetFetchedState
  } = (0, _use_context_app_fetch.useContextAppFetch)({
    anchorId,
    dataView,
    appState,
    useNewFieldsApi
  });

  /**
   * Reset state when anchor changes
   */
  (0, _react.useEffect)(() => {
    if (prevAppState.current) {
      prevAppState.current = undefined;
      resetFetchedState();
    }
  }, [anchorId, resetFetchedState]);

  /**
   * Fetch docs on ui changes
   */
  (0, _react.useEffect)(() => {
    const doFetch = async () => {
      const startTime = window.performance.now();
      let fetchType = '';
      if (!prevAppState.current) {
        fetchType = 'all';
        await fetchAllRows();
      } else if (prevAppState.current.predecessorCount !== appState.predecessorCount) {
        fetchType = 'predecessors';
        await fetchSurroundingRows(_context.SurrDocType.PREDECESSORS);
      } else if (prevAppState.current.successorCount !== appState.successorCount) {
        fetchType = 'successors';
        await fetchSurroundingRows(_context.SurrDocType.SUCCESSORS);
      } else if (!(0, _context_state.isEqualFilters)(prevAppState.current.filters, appState.filters) || !(0, _context_state.isEqualFilters)(prevGlobalState.current.filters, globalState.filters)) {
        fetchType = 'context';
        await fetchContextRows();
      }
      if (analytics) {
        const fetchDuration = window.performance.now() - startTime;
        (0, _ebtTools.reportPerformanceMetricEvent)(analytics, {
          eventName: 'discoverSurroundingDocsFetch',
          duration: fetchDuration,
          meta: {
            fetchType
          }
        });
      }
    };
    doFetch();
    prevAppState.current = (0, _lodash.cloneDeep)(appState);
    prevGlobalState.current = (0, _lodash.cloneDeep)(globalState);
  }, [analytics, appState, globalState, anchorId, fetchContextRows, fetchAllRows, fetchSurroundingRows, fetchedState.anchor.id]);
  const rows = (0, _react.useMemo)(() => [...(fetchedState.predecessors || []), ...(fetchedState.anchor.id ? [fetchedState.anchor] : []), ...(fetchedState.successors || [])], [fetchedState.predecessors, fetchedState.anchor, fetchedState.successors]);
  const interceptedWarnings = (0, _react.useMemo)(() => [...(fetchedState.predecessorsInterceptedWarnings || []), ...(fetchedState.anchorInterceptedWarnings || []), ...(fetchedState.successorsInterceptedWarnings || [])], [fetchedState.predecessorsInterceptedWarnings, fetchedState.anchorInterceptedWarnings, fetchedState.successorsInterceptedWarnings]);
  const addFilter = (0, _react.useCallback)(async (field, values, operation) => {
    const newFilters = (0, _public2.generateFilters)(filterManager, field, values, operation, dataView);
    filterManager.addFilters(newFilters);
    if (dataViews) {
      const fieldName = typeof field === 'string' ? field : field.name;
      await (0, _unifiedDataTable.popularizeField)(dataView, fieldName, dataViews, capabilities);
    }
  }, [filterManager, dataViews, dataView, capabilities]);
  const TopNavMenu = navigation.ui.AggregateQueryTopNavMenu;
  const getNavBarProps = () => {
    return {
      appName: 'context',
      showSearchBar: true,
      showQueryInput: false,
      showFilterBar: true,
      saveQueryMenuVisibility: 'hidden',
      showDatePicker: false,
      indexPatterns: [dataView],
      useDefaultBehaviors: true
    };
  };
  const titlePadding = (0, _eui.useEuiPaddingSize)('m');
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, fetchedState.anchorStatus.value === _context_query_state.LoadingStatus.FAILED ? /*#__PURE__*/_react.default.createElement(_context_error_message.ContextErrorMessage, {
    status: fetchedState.anchorStatus
  }) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("h1", {
    id: "contextAppTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverContextAppTitle"
  }, _i18n.i18n.translate('discover.context.pageTitle', {
    defaultMessage: 'Documents surrounding #{anchorId}',
    values: {
      anchorId
    }
  })), /*#__PURE__*/_react.default.createElement(TopNavMenu, getNavBarProps()), /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: (0, _classnames.default)({
      dscDocsPage: !isLegacy
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true,
    paddingSize: "none",
    className: "dscDocsContent",
    panelProps: {
      role: 'main'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "contextDocumentSurroundingHeader",
    css: (0, _react2.css)`
                  padding: ${titlePadding} ${titlePadding} 0;
                `
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.context.contextOfTitle",
    defaultMessage: "Documents surrounding #{anchorId}",
    values: {
      anchorId
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ContextAppContentMemoized, {
    dataView: dataView,
    useNewFieldsApi: useNewFieldsApi,
    isLegacy: isLegacy,
    columns: columns,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    onSetColumns: onSetColumns,
    predecessorCount: appState.predecessorCount,
    successorCount: appState.successorCount,
    setAppState: stateContainer.setAppState,
    addFilter: addFilter,
    rows: rows,
    predecessors: fetchedState.predecessors,
    successors: fetchedState.successors,
    anchorStatus: fetchedState.anchorStatus.value,
    predecessorsStatus: fetchedState.predecessorsStatus.value,
    successorsStatus: fetchedState.successorsStatus.value,
    interceptedWarnings: interceptedWarnings
  })))));
};
exports.ContextApp = ContextApp;