"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasExactlyOneDataView = exports.getDataViews = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataViews = embeddable => {
  var _embeddable$dataViews;
  if (!(0, _presentationPublishing.apiPublishesDataViews)(embeddable)) return [];
  const dataViews = (_embeddable$dataViews = embeddable.dataViews.getValue()) !== null && _embeddable$dataViews !== void 0 ? _embeddable$dataViews : [];
  return dataViews.reduce((prev, current) => current.id ? [...prev, current.id] : prev, []);
};
exports.getDataViews = getDataViews;
const hasExactlyOneDataView = embeddable => getDataViews(embeddable).length === 1;
exports.hasExactlyOneDataView = hasExactlyOneDataView;