"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexStatsService = void 0;
var _server = require("@kbn/observability-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexStatsService {
  async getIndexStats(esClient, type) {
    try {
      var _indexStats$_all$tota, _indexStats$_all$tota2, _indexStats$_all$tota3, _indexStats$_all$tota4, _indexStats$_all$tota5;
      const index = `${type}-*-*`;
      const indexStats = await esClient.indices.stats({
        index
      });
      return {
        doc_count: (_indexStats$_all$tota = indexStats._all.total) !== null && _indexStats$_all$tota !== void 0 && _indexStats$_all$tota.docs ? (_indexStats$_all$tota2 = indexStats._all.total) === null || _indexStats$_all$tota2 === void 0 ? void 0 : (_indexStats$_all$tota3 = _indexStats$_all$tota2.docs) === null || _indexStats$_all$tota3 === void 0 ? void 0 : _indexStats$_all$tota3.count : 0,
        size_in_bytes: (_indexStats$_all$tota4 = indexStats._all.total) !== null && _indexStats$_all$tota4 !== void 0 && _indexStats$_all$tota4.store ? (_indexStats$_all$tota5 = indexStats._all.total) === null || _indexStats$_all$tota5 === void 0 ? void 0 : _indexStats$_all$tota5.store.size_in_bytes : 0
      };
    } catch (e) {
      if (e.statusCode === 404) {
        return {
          doc_count: 0,
          size_in_bytes: 0
        };
      }
      throw e;
    }
  }
  async getIndexDocCount(esClient, type, start, end) {
    try {
      const index = `${type}-*-*`;
      const query = (0, _server.rangeQuery)(start, end)[0];
      const docCount = await esClient.count({
        index,
        query
      });
      return docCount.count;
    } catch (e) {
      if (e.statusCode === 404) {
        return 0;
      }
      throw e;
    }
  }
}
const indexStatsService = exports.indexStatsService = new IndexStatsService();