"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamService = void 0;
var _utils = require("../../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamService {
  async getMatchingDataStreams(esClient, dataStreamParts) {
    try {
      const {
        data_streams: dataStreamsInfo
      } = await esClient.indices.getDataStream({
        name: (0, _utils.streamPartsToIndexPattern)({
          typePattern: dataStreamParts.type,
          datasetPattern: dataStreamParts.dataset
        })
      });
      return dataStreamsInfo;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
  async getMatchingDataStreamsStats(esClient, dataStreamParts) {
    try {
      const {
        data_streams: dataStreamsStats
      } = await esClient.indices.dataStreamsStats({
        name: (0, _utils.streamPartsToIndexPattern)({
          typePattern: dataStreamParts.type,
          datasetPattern: dataStreamParts.dataset
        }),
        human: true
      });
      return dataStreamsStats;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
  async getDataSteamIndexSettings(esClient, dataStream) {
    try {
      const settings = await esClient.indices.getSettings({
        index: dataStream
      });
      return settings;
    } catch (e) {
      if (e.statusCode === 404) {
        return {};
      }
      throw e;
    }
  }
}
const dataStreamService = exports.dataStreamService = new DataStreamService();