"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _default_api_types = require("../../types/default_api_types");
var _create_datasets_quality_server_route = require("../create_datasets_quality_server_route");
var _get_data_stream_details = require("./get_data_stream_details");
var _get_data_streams = require("./get_data_streams");
var _get_data_streams_stats = require("./get_data_streams_stats");
var _get_degraded_docs = require("./get_degraded_docs");
var _get_estimated_data_in_bytes = require("./get_estimated_data_in_bytes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/stats',
  params: t.type({
    query: t.intersection([_default_api_types.typeRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const [dataStreams, dataStreamsStats] = await Promise.all([(0, _get_data_streams.getDataStreams)({
      esClient,
      ...params.query,
      uncategorisedOnly: false
    }), (0, _get_data_streams_stats.getDataStreamsStats)({
      esClient,
      ...params.query
    })]);
    return {
      dataStreamsStats: (0, _lodash.values)((0, _lodash.merge)((0, _lodash.keyBy)(dataStreams.items, 'name'), (0, _lodash.keyBy)(dataStreamsStats.items, 'name')))
    };
  }
});
const degradedDocsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/degraded_docs',
  params: t.type({
    query: t.intersection([t.partial(_default_api_types.rangeRt.props), _default_api_types.typeRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const degradedDocs = await (0, _get_degraded_docs.getDegradedDocsPaginated)({
      esClient,
      ...params.query
    });
    return {
      degradedDocs
    };
  }
});
const dataStreamDetailsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/details',
  params: t.type({
    path: t.type({
      dataStream: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    var _dataStreamsStats$ite, _dataStreamsStats$ite2;
    const {
      context,
      params
    } = resources;
    const {
      dataStream
    } = params.path;
    const coreContext = await context.core;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const [type, ...datasetQuery] = dataStream.split('-');
    const [dataStreamsStats, dataStreamDetails] = await Promise.all([(0, _get_data_streams_stats.getDataStreamsStats)({
      esClient,
      type: type,
      datasetQuery: datasetQuery.join('-')
    }), (0, _get_data_stream_details.getDataStreamDetails)({
      esClient,
      dataStream
    })]);
    return {
      createdOn: dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.createdOn,
      lastActivity: (_dataStreamsStats$ite = dataStreamsStats.items) === null || _dataStreamsStats$ite === void 0 ? void 0 : (_dataStreamsStats$ite2 = _dataStreamsStats$ite[0]) === null || _dataStreamsStats$ite2 === void 0 ? void 0 : _dataStreamsStats$ite2.lastActivity
    };
  }
});
const estimatedDataInBytesRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/estimated_data',
  params: t.type({
    query: t.intersection([_default_api_types.typeRt, _default_api_types.rangeRt])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const isServerless = (await getEsCapabilities()).serverless;
    if (isServerless) {
      return {
        estimatedDataInBytes: null
      };
    }
    const estimatedDataInBytes = await (0, _get_estimated_data_in_bytes.getEstimatedDataInBytes)({
      esClient,
      ...params.query
    });
    return {
      estimatedDataInBytes
    };
  }
});
const dataStreamsRouteRepository = exports.dataStreamsRouteRepository = {
  ...statsRoute,
  ...degradedDocsRoute,
  ...dataStreamDetailsRoute,
  ...estimatedDataInBytesRoute
};