"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEstimatedDataInBytes = getEstimatedDataInBytes;
var _constants = require("../../../../common/constants");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEstimatedDataInBytes(args) {
  const {
    esClient,
    type = _constants.DEFAULT_DATASET_TYPE,
    start,
    end
  } = args;
  const [{
    doc_count: docCount,
    size_in_bytes: docSize
  }, indexDocCountInTimeRange] = await Promise.all([_services.indexStatsService.getIndexStats(esClient, type), _services.indexStatsService.getIndexDocCount(esClient, type, start, end)]);
  if (!docCount) return 0;
  const avgDocSize = docSize / docCount;
  const estimatedDataInBytes = Math.round(indexDocCountInTimeRange * avgDocSize);
  return estimatedDataInBytes;
}