"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamDetails = getDataStreamDetails;
var _boom = require("@hapi/boom");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamDetails(args) {
  const {
    esClient,
    dataStream
  } = args;
  if (!(dataStream !== null && dataStream !== void 0 && dataStream.trim())) {
    throw (0, _boom.badRequest)(`Data Stream name cannot be empty. Received value "${dataStream}"`);
  }
  const indexSettings = await _services.dataStreamService.getDataSteamIndexSettings(esClient, dataStream);
  const indexesList = Object.values(indexSettings);
  const indexCreationDate = indexesList.map(index => {
    var _index$settings, _index$settings$index;
    return Number((_index$settings = index.settings) === null || _index$settings === void 0 ? void 0 : (_index$settings$index = _index$settings.index) === null || _index$settings$index === void 0 ? void 0 : _index$settings$index.creation_date);
  }).sort((a, b) => a - b)[0];
  return {
    createdOn: indexCreationDate
  };
}