"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchDatasetsQualityFailedNotifier = exports.fetchDatasetsEstimatedDataFailedNotifier = exports.fetchDatasetsActivityFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDatasetsQualityFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetsQualityDetailsFailed', {
      defaultMessage: "We couldn't get your datasets quality details. Default values are shown."
    }),
    text: error.message
  });
};
exports.fetchDatasetsQualityFailedNotifier = fetchDatasetsQualityFailedNotifier;
const fetchDatasetsActivityFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetsActivityFailed', {
      defaultMessage: "We couldn't get your active/inactive datasets details. Default values are shown."
    }),
    text: error.message
  });
};
exports.fetchDatasetsActivityFailedNotifier = fetchDatasetsActivityFailedNotifier;
const fetchDatasetsEstimatedDataFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetsEstimatedDataFailed', {
      defaultMessage: "We couldn't get your datasets estimated data. Default values are shown."
    }),
    text: error.message
  });
};
exports.fetchDatasetsEstimatedDataFailedNotifier = fetchDatasetsEstimatedDataFailedNotifier;