"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPureDatasetQualityControllerStateMachine = exports.createDatasetQualityControllerStateMachine = void 0;
var _timerange = require("@kbn/timerange");
var _xstate = require("xstate");
var _utils = require("../../../../common/utils");
var _utils2 = require("../../../utils");
var _defaults = require("./defaults");
var _notifications = require("./notifications");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPureDatasetQualityControllerStateMachine = initialContext => /** @xstate-layout N4IgpgJg5mDOIC5QBECGAXVszoIoFdUAbAS3QE8BhAewDt0AnaoosBgOggyx1gGIAqgAVkAQQAqAUQD64gJIBZGQCVRAOQDikgNoAGALqJQAB2qwyJOkZAAPRAFZ77AEwAWAGwAOXfc+f39u7uAIwBADQg5IieAMwAnOwA7PbOujHucTHpzs72AL55EWiY2HiEpBQ09EwsbJzcpfzKkgBizQDKABLSYuKieoZIIKbm6Ja01nYIzu4xLv4ZMcGJwZ7OiXERUQieronsurtxibquufYrMQVFDTgExGRUdIzMrBxcJbzsAGY4AMYACxItCgfAgdDA7GBADdqABrSHFHhlB6VZ41N71T7oWA-f5AkEIGHUP4YcYDAbWEYWKxDKbpJwxNJZHIxHK6DKJLaIYI+fauTzBeyuOLOOKuGKxK6FEBI0r3CpPaqvOofZG437oQHA0FsJgcYxEDDfagMAC27Dld3KjyqL1q71uOLxWoJUCJtFhpLGdApBipZhpEzpiD2nhccVWx2CwVch1W9m5Owy7HciT89klIr2rnyMqtKMVdoxqrAUAYqAgkGQJP4wl6MnkSmkqk0On9Q2pPuDoCm3nc7F26aynLOIqTsQSyVS6Uy2Tc11lToVtvRKveZYrVYgNb+TVaHW6vX6HZMge7kx5umWB3WYaynkSMWFE-czlTrj2s2C6yf9mCi4FiuaLKg6nCbpW1a1i62ogmCEJQp68KIsuNogfamJVuWkE7tBmqwe6xLeuSBiUp257jJeCAxiE7AeOmJzPokzF7EmvIXHRgrCqK4qSlkgGoaiSoYaW2HbruGr4jqfB6qa7CGsapoWkBaHCSWG5iVBe4wW6HpemSvqkaewwUbSvY8ss+zXnEsShB49iRlykSIHEhzzMxKQ-s4ni+HmNzYsBanroh6AQd2dYiBIjaKCo6haGRZ6jJRIYIMKqarMsbIhB5QqJs5CCfq4g4xs+nkhDEEruAJAWqcWwXAqF2HhXwzRtJIXQ9BIJ6DIlQZUTkRWZisiQij5qzuBySbOEK7AXCNwTHLxqQpNVyKBXVYENWF4wRQ20hyGoUgaKo8gAPJqO0CUmUlZm2A4HGxJ+Sz+CsDl5dsoRON4mRxvYPgcuKq3yrVa6bfQ210LtUXSGoohKO0QiiJQ7VXV2yXmalngJEyMTDXEKQCksU1pi4cZY2moRzq4QPWkJG2YltTU7YIkVSNIuACJIygAJqo6ZPZ3dRqxFRkszJFluPLGxGzsDZv7pCscbrH5S41XToMM+DTOQzp0ngrQkLEgilqCUWGt1IzFbhbrhJEQZtB+j1119Slua6IOzE+VmPhvm4Sa44yey6AxyzTb4NOFquoGa41Vs7TbuoMPq8lGugJrmibatm9HFta3HOv4bpdvdo7AY3QL9K8rNcTuAK3ixgKyRJoE7t7AHkZxKKDlVfmptRyJHCW-buJENQOEs3tfQAEIADIyJQyhyFIi-dWXLsY2m4a8Y+-7LJvSYTYNWQ1xkFyPjMEfrebg958P7Cj+P4inRoGhz-tsOUPIABqMjHu0kjiEusZNGt0+wzHYBlUUWNj4XFcEmCU+w2Q-lnP4T8mRL4gxzjfWOd8H7bj4E-F+b8WgCBnjPTqfR-7iBhnDFGwD+ZUUFPsea14BS6EyFGf26ROKhw5FjDwAoVYqXVlgn4RByDUHwOgPg-856fxhpIAA6hQ0QVC+blyoimdhvgTiZmcFkBBbEKpFSfN5ZIwQ2S42pr3LO-d1JiIkVIvglAZ6nX-tIFoM9uanQEOIdR69Bb-icJ+RwARYysifEY0IsssZ+A2KcCqmYMEiIHg4yR6BEIWAeAALz1ghWAmBQqZzWpg1J3xxHpMyWMHJOp-EXhSryGacZEj6O8p3XGxw2L4zmMkGywpprDXWMk7OZSKlSKqSQGpIIsSoHaIwMAqAzTIBwKgEgRBJKujyQbRCsJjbCJGfY8pjiMnAiyaQXJ0y1RzIYAspZKy1kbIInpEk9tS7kQ0a7fRqYVhYwWv+XMViuluHYLjYx6xBTsk8MMuxwUjmVNOdU85OoZnXNucszADyE4ySTnJBSaclLFOBikw5YyTm0DOSQC5UAUXzMWei1Z6yE7POIoZfQdT0aCzOMEJI2jryxiCaKJyH10xTl4r4fwPhhSJGhehElxyJlTOpUPbsaBYAAgAEZjwYBAR5bp4LbKNihWxsrYWkoVUi6Zyrxiqo1VqnVTLi4kTZfQj5GM0EuCWN5NY1k1h+3yjkRwEDQ4BAmiOR8MqgpgTheMhFkyLVKtviqrAtrUDat1dJWSBpU7p2Un3E1UazWxsVSFCGtAbWatTfawuOpmWvKMk7EBFdQwig9T+PwqQFq+rgf60I74rEXF0OsTIpwI30zqNGjJeDIDONce4zx3jfHstAYgEaCQT6jWWjmZwbE9hODFKHY4iwghQpsSU4lpr5VTogBPaGB12hyA0J0QBsgYotjiu2BtDCGmdoOEybR4TDjMTYrA1MQRUjBxrrkLwo7r5pPGX8Ue2Br2nSEJINQHivE+L8S6gJUxwUQIqsxNMMxEi13SDumuBx-D40fKcE4J6ZS0GoFWeAQx9kwodGvepGMAC0rhuWSlWCRyUA1djvUQDxre00cwZE-LoYO-gYOiLVI0LjHKpj7DcF4HwfgQ0hHCPlacIKFhiiyJKR81j-JnoOcFFTXxq0gjU8uoW4Z5O7DSIKSUswBRJnFAOLIvhPwzElhkJTqS7POivU5ptqVwFCksSJiU-Hgi+Z8rNGYf0mR-XWOkML9isJbi0qx3q3HBbJHDEOKUo43CbEMykYzYG5zmZGnl2zEFxJ4Sko595uHoiRlmvxxwrkuInBS-lY4744n+FCN4Ea6ZWtgQKzhCS98x7bmi1RCxaW1h6Nco4CqaQ2LXjmMRxw15DhsmFAtmOpbivO1K1MAcIQmFZUskE8TCB0x0QlJkMUPgDFLGu7nHB1sHNQA2w08USRYi128Bmc+7gppQ8Ysgi434fJCLzZGm72taAjzW5ACHG8zgQN8KESUwdgtCocDkA4AQRTsLo14OIQOOATqJ2Vun9FZwnDTHNtiOQEhvk-N4JkHheTOFZ3BslFKqUc6mIGjk3POQcg8mxEITgOQVUFIzrMlnVbWY45iCd5rKXIqubSu5GL1ny6vHMJYsxIyEfxtNRH+VliDrol63TrkYz4ylybot8aaU3LpfcxlYPbfUX-CC8nTu9gu9CGxXYRVTiOVmFxbykvT1EpswW+VQezeXO4KisP1vcT6zAFH0+ECctCkjOcIIyeHLfN5LsGM00KrZ6s7no347C3ksRUXhNIPrXJorWmqPvI5hK7TDz1XTd-XB01+w1YLT4isIDwP2XyKrV0HLXa9N3WSvqZ5DH2fT4Vd84+wMkxPFO4zjTD3HvtM8-G+30PqlJbccH8rRXiEUepG7sYGmYFiwoSCMQU0C0rcsYrkiwZwawW+l6BOEAU+wc3KHCjEaOYoQG7ugQCQ-gHawW-GsQ3eBuve+a7+8qCGZghOPWD290A44oLSg66+2YkB7uEo742iTIywvgg6K0BQeQQAA */
(0, _xstate.createMachine)({
  context: initialContext,
  predictableActionArguments: true,
  id: 'DatasetQualityController',
  type: 'parallel',
  states: {
    datasets: {
      initial: 'fetching',
      states: {
        fetching: {
          invoke: {
            src: 'loadDataStreamStats',
            onDone: {
              target: 'loaded',
              actions: ['storeDataStreamStats', 'storeDatasets']
            },
            onError: {
              target: 'loaded',
              actions: ['notifyFetchDatasetStatsFailed']
            }
          }
        },
        loaded: {}
      },
      on: {
        UPDATE_TIME_RANGE: {
          target: 'datasets.fetching',
          actions: ['storeTimeRange']
        },
        REFRESH_DATA: {
          target: 'datasets.fetching'
        }
      }
    },
    degradedDocs: {
      initial: 'fetching',
      states: {
        fetching: {
          invoke: {
            src: 'loadDegradedDocs',
            onDone: {
              target: 'loaded',
              actions: ['storeDegradedDocStats', 'storeDatasets']
            },
            onError: {
              target: 'loaded',
              actions: ['notifyFetchDegradedStatsFailed']
            }
          }
        },
        loaded: {}
      },
      on: {
        UPDATE_TIME_RANGE: {
          target: 'degradedDocs.fetching',
          actions: ['storeTimeRange']
        },
        REFRESH_DATA: {
          target: 'degradedDocs.fetching'
        }
      }
    },
    integrations: {
      initial: 'fetching',
      states: {
        fetching: {
          invoke: {
            src: 'loadIntegrations',
            onDone: {
              target: 'loaded',
              actions: ['storeIntegrations', 'storeDatasets']
            },
            onError: {
              target: 'loaded',
              actions: ['notifyFetchIntegrationsFailed', 'storeEmptyIntegrations', 'storeDatasets']
            }
          }
        },
        loaded: {
          on: {
            UPDATE_TABLE_CRITERIA: {
              target: 'loaded',
              actions: ['storeTableOptions']
            },
            TOGGLE_INACTIVE_DATASETS: {
              target: 'loaded',
              actions: ['storeInactiveDatasetsVisibility', 'resetPage']
            },
            TOGGLE_FULL_DATASET_NAMES: {
              target: 'loaded',
              actions: ['storeFullDatasetNamesVisibility']
            }
          }
        }
      },
      on: {
        UPDATE_TIME_RANGE: {
          target: 'integrations.fetching',
          actions: ['storeTimeRange']
        },
        REFRESH_DATA: {
          target: 'integrations.fetching'
        },
        UPDATE_INTEGRATIONS: {
          target: 'integrations.loaded',
          actions: ['storeIntegrationsFilter']
        },
        UPDATE_NAMESPACES: {
          target: 'integrations.loaded',
          actions: ['storeNamespaces']
        },
        UPDATE_QUERY: {
          actions: ['storeQuery']
        }
      }
    },
    flyout: {
      initial: 'closed',
      states: {
        initializing: {
          type: 'parallel',
          states: {
            dataStreamDetails: {
              initial: 'fetching',
              states: {
                fetching: {
                  invoke: {
                    src: 'loadDataStreamDetails',
                    onDone: {
                      target: 'done',
                      actions: ['storeDatasetDetails']
                    },
                    onError: {
                      target: 'done',
                      actions: ['fetchDatasetDetailsFailedNotifier']
                    }
                  }
                },
                done: {
                  type: 'final'
                }
              }
            },
            integrationDashboards: {
              initial: 'fetching',
              states: {
                fetching: {
                  invoke: {
                    src: 'loadIntegrationDashboards',
                    onDone: {
                      target: 'done',
                      actions: ['storeIntegrationDashboards']
                    },
                    onError: {
                      target: 'done',
                      actions: ['notifyFetchIntegrationDashboardsFailed']
                    }
                  }
                },
                done: {
                  type: 'final'
                }
              }
            }
          },
          onDone: {
            target: '#DatasetQualityController.flyout.loaded'
          }
        },
        loaded: {
          on: {
            CLOSE_FLYOUT: {
              target: 'closed',
              actions: ['resetFlyoutOptions']
            },
            UPDATE_INSIGHTS_TIME_RANGE: {
              actions: ['storeFlyoutOptions']
            },
            BREAKDOWN_FIELD_CHANGE: {
              actions: ['storeFlyoutOptions']
            }
          }
        },
        closed: {
          on: {
            OPEN_FLYOUT: {
              target: '#DatasetQualityController.flyout.initializing',
              actions: ['storeFlyoutOptions']
            }
          }
        }
      },
      on: {
        SELECT_NEW_DATASET: {
          target: '#DatasetQualityController.flyout.initializing',
          actions: ['storeFlyoutOptions']
        },
        CLOSE_FLYOUT: {
          target: '#DatasetQualityController.flyout.closed',
          actions: ['resetFlyoutOptions']
        }
      }
    }
  }
}, {
  actions: {
    storeTableOptions: (0, _xstate.assign)((_context, event) => {
      return 'criteria' in event ? {
        table: event.criteria
      } : {};
    }),
    resetPage: (0, _xstate.assign)((context, _event) => ({
      table: {
        ...context.table,
        page: 0
      }
    })),
    storeInactiveDatasetsVisibility: (0, _xstate.assign)((context, _event) => {
      return {
        filters: {
          ...context.filters,
          inactive: !context.filters.inactive
        }
      };
    }),
    storeFullDatasetNamesVisibility: (0, _xstate.assign)((context, _event) => {
      return {
        filters: {
          ...context.filters,
          fullNames: !context.filters.fullNames
        }
      };
    }),
    storeTimeRange: (0, _xstate.assign)((context, event) => {
      return 'timeRange' in event ? {
        filters: {
          ...context.filters,
          timeRange: event.timeRange
        }
      } : {};
    }),
    storeIntegrationsFilter: (0, _xstate.assign)((context, event) => {
      return 'integrations' in event ? {
        filters: {
          ...context.filters,
          integrations: event.integrations
        }
      } : {};
    }),
    storeNamespaces: (0, _xstate.assign)((context, event) => {
      return 'namespaces' in event ? {
        filters: {
          ...context.filters,
          namespaces: event.namespaces
        }
      } : {};
    }),
    storeQuery: (0, _xstate.assign)((context, event) => {
      return 'query' in event ? {
        filters: {
          ...context.filters,
          query: event.query
        }
      } : {};
    }),
    storeFlyoutOptions: (0, _xstate.assign)((context, event) => {
      var _event$breakdownField;
      return 'dataset' in event ? {
        flyout: {
          ...context.flyout,
          dataset: event.dataset
        }
      } : 'timeRange' in event ? {
        flyout: {
          ...context.flyout,
          insightsTimeRange: event.timeRange
        }
      } : 'breakdownField' in event ? {
        flyout: {
          ...context.flyout,
          breakdownField: (_event$breakdownField = event.breakdownField) !== null && _event$breakdownField !== void 0 ? _event$breakdownField : undefined
        }
      } : {};
    }),
    resetFlyoutOptions: (0, _xstate.assign)((_context, _event) => ({
      flyout: undefined
    })),
    storeDataStreamStats: (0, _xstate.assign)((_context, event) => {
      return 'data' in event ? {
        dataStreamStats: event.data
      } : {};
    }),
    storeDegradedDocStats: (0, _xstate.assign)((_context, event) => {
      return 'data' in event ? {
        degradedDocStats: event.data
      } : {};
    }),
    storeDatasetDetails: (0, _xstate.assign)((context, event) => {
      return 'data' in event ? {
        flyout: {
          ...context.flyout,
          datasetDetails: event.data
        }
      } : {};
    }),
    storeIntegrations: (0, _xstate.assign)((_context, event) => {
      return 'data' in event ? {
        integrations: event.data
      } : {};
    }),
    storeEmptyIntegrations: (0, _xstate.assign)(_context => {
      return {
        integrations: []
      };
    }),
    storeIntegrationDashboards: (0, _xstate.assign)((context, event) => {
      var _context$flyout$datas;
      return 'data' in event && 'dashboards' in event.data ? {
        flyout: {
          ...context.flyout,
          dataset: {
            ...context.flyout.dataset,
            integration: {
              ...((_context$flyout$datas = context.flyout.dataset) === null || _context$flyout$datas === void 0 ? void 0 : _context$flyout$datas.integration),
              dashboards: event.data.dashboards
            }
          }
        }
      } : {};
    }),
    storeDatasets: (0, _xstate.assign)((context, _event) => {
      return context.integrations && (context.dataStreamStats || context.degradedDocStats) ? {
        datasets: (0, _utils2.generateDatasets)(context.dataStreamStats, context.degradedDocStats, context.integrations)
      } : {};
    })
  }
});
exports.createPureDatasetQualityControllerStateMachine = createPureDatasetQualityControllerStateMachine;
const createDatasetQualityControllerStateMachine = ({
  initialContext = _defaults.DEFAULT_CONTEXT,
  toasts,
  dataStreamStatsClient,
  dataStreamDetailsClient
}) => createPureDatasetQualityControllerStateMachine(initialContext).withConfig({
  actions: {
    notifyFetchDatasetStatsFailed: (_context, event) => (0, _notifications.fetchDatasetStatsFailedNotifier)(toasts, event.data),
    notifyFetchDegradedStatsFailed: (_context, event) => (0, _notifications.fetchDegradedStatsFailedNotifier)(toasts, event.data),
    notifyFetchDatasetDetailsFailed: (_context, event) => (0, _notifications.fetchDatasetDetailsFailedNotifier)(toasts, event.data),
    notifyFetchIntegrationDashboardsFailed: (_context, event) => (0, _notifications.fetchIntegrationDashboardsFailedNotifier)(toasts, event.data),
    notifyFetchIntegrationsFailed: (_context, event) => (0, _notifications.fetchIntegrationsFailedNotifier)(toasts, event.data)
  },
  services: {
    loadDataStreamStats: context => dataStreamStatsClient.getDataStreamsStats({
      type: context.type,
      datasetQuery: context.filters.query
    }),
    loadDegradedDocs: context => {
      const {
        startDate: start,
        endDate: end
      } = (0, _timerange.getDateISORange)(context.filters.timeRange);
      return dataStreamStatsClient.getDataStreamsDegradedStats({
        type: context.type,
        datasetQuery: context.filters.query,
        start,
        end
      });
    },
    loadIntegrations: context => {
      return dataStreamStatsClient.getIntegrations({
        type: context.type
      });
    },
    loadDataStreamDetails: context => {
      if (!context.flyout.dataset) {
        (0, _notifications.fetchDatasetDetailsFailedNotifier)(toasts, new Error(_notifications.noDatasetSelected));
        return Promise.resolve({});
      }
      const {
        type,
        name: dataset,
        namespace
      } = context.flyout.dataset;
      return dataStreamDetailsClient.getDataStreamDetails({
        dataStream: (0, _utils.dataStreamPartsToIndexName)({
          type: type,
          dataset,
          namespace
        })
      });
    },
    loadIntegrationDashboards: context => {
      if (!context.flyout.dataset) {
        (0, _notifications.fetchDatasetDetailsFailedNotifier)(toasts, new Error(_notifications.noDatasetSelected));
        return Promise.resolve({});
      }
      const {
        integration
      } = context.flyout.dataset;
      return integration ? dataStreamDetailsClient.getIntegrationDashboards({
        integration: integration.name
      }) : Promise.resolve({});
    }
  }
});
exports.createDatasetQualityControllerStateMachine = createDatasetQualityControllerStateMachine;