"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSummaryPanelContext = exports.default = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("@xstate/react");
var _summary_panel = require("../state_machines/summary_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSummaryPanel = ({
  dataStreamStatsClient,
  toasts
}) => {
  const summaryPanelStateService = (0, _react.useInterpret)(() => (0, _summary_panel.createDatasetsSummaryPanelStateMachine)({
    dataStreamStatsClient,
    toasts
  }));

  /*
    Datasets Quality
  */
  const datasetsQuality = (0, _react.useSelector)(summaryPanelStateService, state => state.context.datasetsQuality);
  const isDatasetsQualityLoading = (0, _react.useSelector)(summaryPanelStateService, state => state.matches('datasetsQuality.fetching') || state.matches('datasetsQuality.retrying') || state.matches('datasetsActivity.fetching'));

  /*
    Datasets Activity
  */
  const datasetsActivity = (0, _react.useSelector)(summaryPanelStateService, state => state.context.datasetsActivity);
  const isDatasetsActivityLoading = (0, _react.useSelector)(summaryPanelStateService, state => state.matches('datasetsActivity.fetching') || state.matches('datasetsActivity.retrying'));

  /*
    Estimated Data
  */
  const estimatedData = (0, _react.useSelector)(summaryPanelStateService, state => state.context.estimatedData);
  const isEstimatedDataLoading = (0, _react.useSelector)(summaryPanelStateService, state => state.matches('estimatedData.fetching') || state.matches('estimatedData.retrying'));
  const isEstimatedDataDisabled = (0, _react.useSelector)(summaryPanelStateService, state => state.matches('estimatedData.disabled'));
  return {
    datasetsQuality,
    isDatasetsQualityLoading,
    isEstimatedDataLoading,
    estimatedData,
    isEstimatedDataDisabled,
    isDatasetsActivityLoading,
    datasetsActivity
  };
};
const [SummaryPanelProvider, useSummaryPanelContext] = (0, _constate.default)(useSummaryPanel);
exports.useSummaryPanelContext = useSummaryPanelContext;
// eslint-disable-next-line import/no-default-export
var _default = exports.default = SummaryPanelProvider;