"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutIntegrationActions = void 0;
var _routerUtils = require("@kbn/router-utils");
var _react = require("react");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _constants = require("@kbn/deeplinks-management/constants");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFlyoutIntegrationActions = () => {
  const {
    services: {
      application: {
        navigateToUrl
      },
      http: {
        basePath
      },
      share
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const [isOpen, toggleIsOpen] = (0, _useToggle.default)(false);
  const dashboardLocator = (0, _react.useMemo)(() => share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR), [share.url.locators]);
  const indexManagementLocator = (0, _react.useMemo)(() => share.url.locators.get(_constants.MANAGEMENT_APP_LOCATOR), [share.url.locators]);
  const handleCloseMenu = (0, _react.useCallback)(() => {
    toggleIsOpen();
  }, [toggleIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => {
    toggleIsOpen();
  }, [toggleIsOpen]);
  const getIntegrationOverviewLinkProps = (0, _react.useCallback)((name, version) => {
    const href = basePath.prepend(`/app/integrations/detail/${name}-${version}/overview`);
    return (0, _routerUtils.getRouterLinkProps)({
      href,
      onClick: () => navigateToUrl(href)
    });
  }, [basePath, navigateToUrl]);
  const getIndexManagementLinkProps = (0, _react.useCallback)(params => (0, _routerUtils.getRouterLinkProps)({
    href: indexManagementLocator === null || indexManagementLocator === void 0 ? void 0 : indexManagementLocator.getRedirectUrl(params),
    onClick: () => indexManagementLocator === null || indexManagementLocator === void 0 ? void 0 : indexManagementLocator.navigate(params)
  }), [indexManagementLocator]);
  const getDashboardLinkProps = (0, _react.useCallback)(dashboard => (0, _routerUtils.getRouterLinkProps)({
    href: dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId: dashboard === null || dashboard === void 0 ? void 0 : dashboard.id
    } || ''),
    onClick: () => dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.navigate({
      dashboardId: dashboard === null || dashboard === void 0 ? void 0 : dashboard.id
    } || '')
  }), [dashboardLocator]);
  return {
    isOpen,
    handleCloseMenu,
    handleToggleMenu,
    getIntegrationOverviewLinkProps,
    getIndexManagementLinkProps,
    getDashboardLinkProps
  };
};
exports.useFlyoutIntegrationActions = useFlyoutIntegrationActions;