"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityTable = void 0;
var _react = require("@xstate/react");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../common/constants");
var _translations = require("../../common/translations");
var _columns = require("../components/dataset_quality/table/columns");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
var _filter_inactive_datasets = require("../utils/filter_inactive_datasets");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortingOverrides = {
  ['title']: 'name',
  ['size']: 'sizeBytes'
};
const useDatasetQualityTable = () => {
  var _flyout$dataset2;
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    page,
    rowsPerPage,
    sort
  } = (0, _react.useSelector)(service, state => state.context.table);
  const {
    inactive: showInactiveDatasets,
    fullNames: showFullDatasetNames,
    timeRange,
    integrations,
    namespaces,
    query
  } = (0, _react.useSelector)(service, state => state.context.filters);
  const flyout = (0, _react.useSelector)(service, state => state.context.flyout);
  const loading = (0, _react.useSelector)(service, state => state.matches('datasets.fetching') || state.matches('integrations.fetching') || state.matches('degradedDocs.fetching'));
  const loadingDataStreamStats = (0, _react.useSelector)(service, state => state.matches('datasets.fetching'));
  const loadingDegradedStats = (0, _react.useSelector)(service, state => state.matches('degradedDocs.fetching'));
  const datasets = (0, _react.useSelector)(service, state => state.context.datasets);
  const isDatasetQualityPageIdle = (0, _react.useSelector)(service, state => state.matches('datasets.loaded.idle'));
  const toggleInactiveDatasets = (0, _react2.useCallback)(() => service.send({
    type: 'TOGGLE_INACTIVE_DATASETS'
  }), [service]);
  const toggleFullDatasetNames = (0, _react2.useCallback)(() => service.send({
    type: 'TOGGLE_FULL_DATASET_NAMES'
  }), [service]);
  const closeFlyout = (0, _react2.useCallback)(() => service.send({
    type: 'CLOSE_FLYOUT'
  }), [service]);
  const openFlyout = (0, _react2.useCallback)(selectedDataset => {
    var _flyout$dataset;
    if ((flyout === null || flyout === void 0 ? void 0 : (_flyout$dataset = flyout.dataset) === null || _flyout$dataset === void 0 ? void 0 : _flyout$dataset.rawName) === selectedDataset.rawName) {
      service.send({
        type: 'CLOSE_FLYOUT'
      });
      return;
    }
    if (isDatasetQualityPageIdle) {
      service.send({
        type: 'OPEN_FLYOUT',
        dataset: selectedDataset
      });
      return;
    }
    service.send({
      type: 'SELECT_NEW_DATASET',
      dataset: selectedDataset
    });
  }, [flyout === null || flyout === void 0 ? void 0 : (_flyout$dataset2 = flyout.dataset) === null || _flyout$dataset2 === void 0 ? void 0 : _flyout$dataset2.rawName, isDatasetQualityPageIdle, service]);
  const isActive = (0, _react2.useCallback)(lastActivity => (0, _filter_inactive_datasets.isActiveDataset)({
    lastActivity,
    timeRange
  }), [timeRange]);
  const columns = (0, _react2.useMemo)(() => (0, _columns.getDatasetQualityTableColumns)({
    fieldFormats,
    selectedDataset: flyout === null || flyout === void 0 ? void 0 : flyout.dataset,
    openFlyout,
    loadingDataStreamStats,
    loadingDegradedStats,
    showFullDatasetNames,
    isActiveDataset: isActive
  }), [fieldFormats, flyout === null || flyout === void 0 ? void 0 : flyout.dataset, openFlyout, loadingDataStreamStats, loadingDegradedStats, showFullDatasetNames, isActive]);
  const filteredItems = (0, _react2.useMemo)(() => {
    const visibleDatasets = showInactiveDatasets ? datasets : (0, _filter_inactive_datasets.filterInactiveDatasets)({
      datasets,
      timeRange
    });
    const filteredByIntegrations = integrations.length > 0 ? visibleDatasets.filter(dataset => {
      if (!dataset.integration && integrations.includes(_constants.NONE)) {
        return true;
      }
      return dataset.integration && integrations.includes(dataset.integration.name);
    }) : visibleDatasets;
    const filteredByNamespaces = namespaces.length > 0 ? filteredByIntegrations.filter(dataset => namespaces.includes(dataset.namespace)) : filteredByIntegrations;
    return query ? filteredByNamespaces.filter(dataset => dataset.rawName.includes(query)) : filteredByNamespaces;
  }, [showInactiveDatasets, datasets, timeRange, integrations, namespaces, query]);
  const pagination = {
    pageIndex: page,
    pageSize: rowsPerPage,
    totalItemCount: filteredItems.length,
    hidePerPageOptions: true
  };
  const onTableChange = (0, _react2.useCallback)(options => {
    var _options$sort, _options$sort2;
    service.send({
      type: 'UPDATE_TABLE_CRITERIA',
      criteria: {
        page: options.page.index,
        rowsPerPage: options.page.size,
        sort: {
          field: ((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || _constants.DEFAULT_SORT_FIELD,
          direction: ((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || _constants.DEFAULT_SORT_DIRECTION
        }
      }
    });
  }, [service]);
  const renderedItems = (0, _react2.useMemo)(() => {
    const overridenSortingField = sortingOverrides[sort.field] || sort.field;
    const sortedItems = (0, _lodash.orderBy)(filteredItems, overridenSortingField, sort.direction);
    return sortedItems.slice(page * rowsPerPage, (page + 1) * rowsPerPage);
  }, [sort.field, sort.direction, filteredItems, page, rowsPerPage]);
  const resultsCount = (0, _react2.useMemo)(() => {
    const startNumberItemsOnPage = rowsPerPage * page + (renderedItems.length ? 1 : 0);
    const endNumberItemsOnPage = rowsPerPage * page + renderedItems.length;
    return rowsPerPage === 0 ? /*#__PURE__*/_react2.default.createElement("strong", null, _translations.tableSummaryAllText) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("strong", null, startNumberItemsOnPage, "-", endNumberItemsOnPage), ' ', _translations.tableSummaryOfText, " ", datasets.length);
  }, [rowsPerPage, page, renderedItems.length, datasets.length]);
  return {
    sort: {
      sort
    },
    onTableChange,
    pagination,
    renderedItems,
    columns,
    loading,
    resultsCount,
    closeFlyout,
    selectedDataset: flyout === null || flyout === void 0 ? void 0 : flyout.dataset,
    showInactiveDatasets,
    showFullDatasetNames,
    toggleInactiveDatasets,
    toggleFullDatasetNames
  };
};
exports.useDatasetQualityTable = useDatasetQualityTable;