"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPublicStateFromContext = exports.getContextFromPublicState = void 0;
var _dataset_quality_controller = require("../state_machines/dataset_quality_controller");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPublicStateFromContext = context => {
  return {
    table: context.table,
    flyout: context.flyout,
    filters: context.filters
  };
};
exports.getPublicStateFromContext = getPublicStateFromContext;
const getContextFromPublicState = publicState => {
  var _publicState$table, _publicState$table2, _publicState$table3;
  return {
    ..._dataset_quality_controller.DEFAULT_CONTEXT,
    table: {
      ..._dataset_quality_controller.DEFAULT_CONTEXT.table,
      ...publicState.table,
      sort: (_publicState$table = publicState.table) !== null && _publicState$table !== void 0 && _publicState$table.sort ? {
        ...((_publicState$table2 = publicState.table) === null || _publicState$table2 === void 0 ? void 0 : _publicState$table2.sort),
        field: (_publicState$table3 = publicState.table) === null || _publicState$table3 === void 0 ? void 0 : _publicState$table3.sort.field
      } : _dataset_quality_controller.DEFAULT_CONTEXT.table.sort
    },
    flyout: {
      ..._dataset_quality_controller.DEFAULT_CONTEXT.flyout,
      ...publicState.flyout
    },
    filters: {
      ..._dataset_quality_controller.DEFAULT_CONTEXT.filters,
      ...publicState.filters
    }
  };
};
exports.getContextFromPublicState = getContextFromPublicState;