"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationActionsMenu = IntegrationActionsMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hooks = require("../../hooks");
var _use_flyout_integration_actions = require("../../hooks/use_flyout_integration_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const seeIntegrationText = _i18n.i18n.translate('xpack.datasetQuality.flyoutSeeIntegrationActionText', {
  defaultMessage: 'See integration'
});
const indexTemplateText = _i18n.i18n.translate('xpack.datasetQuality.flyoutIndexTemplateActionText', {
  defaultMessage: 'Index template'
});
const viewDashboardsText = _i18n.i18n.translate('xpack.datasetQuality.flyoutViewDashboardsActionText', {
  defaultMessage: 'View dashboards'
});
function IntegrationActionsMenu({
  integration
}) {
  const {
    type,
    name
  } = (0, _hooks.useDatasetQualityFlyout)().dataStreamStat;
  const {
    dashboards = [],
    version,
    name: integrationName
  } = integration;
  const {
    isOpen,
    handleCloseMenu,
    handleToggleMenu,
    getIntegrationOverviewLinkProps,
    getIndexManagementLinkProps,
    getDashboardLinkProps
  } = (0, _use_flyout_integration_actions.useFlyoutIntegrationActions)();
  const actionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "boxesHorizontal",
    onClick: handleToggleMenu,
    "data-test-subj": "datasetQualityFlyoutIntegrationActionsButton"
  });
  const MenuActionItem = ({
    dataTestSubject,
    buttonText,
    routerLinkProps,
    iconType
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, routerLinkProps, {
    size: "s",
    css: (0, _react2.css)`
        font-weight: normal;
      `,
    color: "text",
    iconType: iconType,
    "data-test-subj": dataTestSubject
  }), buttonText);
  const panelItems = (0, _react.useMemo)(() => {
    const firstLevelItems = [{
      renderItem: () => /*#__PURE__*/_react.default.createElement(MenuActionItem, {
        buttonText: seeIntegrationText,
        dataTestSubject: "datasetQualityFlyoutIntegrationActionOverview",
        routerLinkProps: getIntegrationOverviewLinkProps(integrationName, version),
        iconType: "package"
      })
    }, {
      renderItem: () => /*#__PURE__*/_react.default.createElement(MenuActionItem, {
        buttonText: indexTemplateText,
        dataTestSubject: "datasetQualityFlyoutIntegrationActionTemplate",
        routerLinkProps: getIndexManagementLinkProps({
          sectionId: 'data',
          appId: `index_management/templates/${type}-${name}`
        }),
        iconType: "indexPatternApp"
      })
    }, {
      isSeparator: true,
      key: 'sep'
    }];
    if (dashboards.length) {
      firstLevelItems.push({
        icon: 'dashboardApp',
        panel: 1,
        name: viewDashboardsText,
        'data-test-subj': 'datasetQualityFlyoutIntegrationActionViewDashboards'
      });
    }
    const panel = [{
      id: 0,
      items: firstLevelItems
    }, {
      id: 1,
      title: viewDashboardsText,
      items: dashboards.map(dashboard => {
        return {
          renderItem: () => /*#__PURE__*/_react.default.createElement(MenuActionItem, {
            buttonText: dashboard.title,
            dataTestSubject: "datasetQualityFlyoutIntegrationActionDashboard",
            routerLinkProps: getDashboardLinkProps(dashboard),
            iconType: "dashboardApp"
          })
        };
      })
    }];
    return panel;
  }, [dashboards, getDashboardLinkProps, getIndexManagementLinkProps, getIntegrationOverviewLinkProps, integrationName, name, type, version]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    button: actionButton,
    isOpen: isOpen,
    closePopover: handleCloseMenu
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    panels: panelItems,
    initialPanelId: 0
  }));
}