"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _translations = require("../../../common/translations");
var _hooks = require("../../hooks");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Header({
  dataStreamStat
}) {
  const {
    integration,
    title
  } = dataStreamStat;
  const euiShadow = (0, _eui.useEuiShadow)('s');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const logsExplorerLinkProps = (0, _hooks.useLinkToLogsExplorer)({
    dataStreamStat
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "datasetQualityFlyoutTitle"
  }, /*#__PURE__*/_react2.default.createElement("h3", null, title)), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                ${euiShadow};
                padding: ${euiTheme.size.xs};
                border-radius: ${euiTheme.size.xxs};
              `
  }, /*#__PURE__*/_react2.default.createElement(_common.IntegrationIcon, {
    integration: integration
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
              margin-right: ${euiTheme.size.l};
            `,
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "datasetQualityHeaderButton",
    size: "s"
  }, logsExplorerLinkProps, {
    iconType: "logoObservability"
  }), _translations.flyoutOpenInLogsExplorerText)))));
}