"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatasetQualityTableColumns = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _formatters = require("@kbn/formatters");
var _constants = require("../../../../common/constants");
var _quality_indicator = require("../../quality_indicator");
var _common = require("../../common");
var _hooks = require("../../../hooks");
var _degraded_docs_percentage_link = require("./degraded_docs_percentage_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expandDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.expandLabel', {
  defaultMessage: 'Expand'
});
const collapseDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.collapseLabel', {
  defaultMessage: 'Collapse'
});
const nameColumnName = _i18n.i18n.translate('xpack.datasetQuality.nameColumnName', {
  defaultMessage: 'Dataset Name'
});
const namespaceColumnName = _i18n.i18n.translate('xpack.datasetQuality.namespaceColumnName', {
  defaultMessage: 'Namespace'
});
const sizeColumnName = _i18n.i18n.translate('xpack.datasetQuality.sizeColumnName', {
  defaultMessage: 'Size'
});
const degradedDocsColumnName = _i18n.i18n.translate('xpack.datasetQuality.degradedDocsColumnName', {
  defaultMessage: 'Degraded Docs'
});
const lastActivityColumnName = _i18n.i18n.translate('xpack.datasetQuality.lastActivityColumnName', {
  defaultMessage: 'Last Activity'
});
const actionsColumnName = _i18n.i18n.translate('xpack.datasetQuality.actionsColumnName', {
  defaultMessage: 'Actions'
});
const openActionName = _i18n.i18n.translate('xpack.datasetQuality.openActionName', {
  defaultMessage: 'Open'
});
const inactiveDatasetActivityColumnDescription = _i18n.i18n.translate('xpack.datasetQuality.inactiveDatasetActivityColumnDescription', {
  defaultMessage: 'No activity in the selected timeframe'
});
const inactiveDatasetActivityColumnTooltip = _i18n.i18n.translate('xpack.datasetQuality.inactiveDatasetActivityColumnTooltip', {
  defaultMessage: 'Try expanding the time range above for more results'
});
const degradedDocsDescription = minimimPercentage => _i18n.i18n.translate('xpack.datasetQuality.degradedDocsQualityDescription', {
  defaultMessage: 'greater than {minimimPercentage}%',
  values: {
    minimimPercentage
  }
});
const degradedDocsColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.degradedDocsColumnTooltip",
  defaultMessage: "The percentage of degraded documents \u2014documents with the {ignoredProperty} property\u2014 in your dataset. {visualQueue}",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored"),
    visualQueue: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "poor",
      description: ` ${degradedDocsDescription(_constants.POOR_QUALITY_MINIMUM_PERCENTAGE)}`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "degraded",
      description: ` ${degradedDocsDescription(_constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE)}`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "good",
      description: ' 0%'
    })))
  }
});
const getDatasetQualityTableColumns = ({
  fieldFormats,
  selectedDataset,
  openFlyout,
  loadingDataStreamStats,
  loadingDegradedStats,
  showFullDatasetNames,
  isActiveDataset
}) => {
  return [{
    name: '',
    render: dataStreamStat => {
      const isExpanded = dataStreamStat.rawName === (selectedDataset === null || selectedDataset === void 0 ? void 0 : selectedDataset.rawName);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "datasetQualityExpandButton",
        size: "m",
        color: "text",
        onClick: () => openFlyout(dataStreamStat),
        iconType: isExpanded ? 'minimize' : 'expand',
        title: !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel,
        "aria-label": !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel
      });
    },
    width: '40px',
    css: (0, _react2.css)`
        &.euiTableCellContent {
          padding: 0;
        }
      `
  }, {
    name: nameColumnName,
    field: 'title',
    sortable: true,
    render: (title, dataStreamStat) => {
      const {
        integration,
        name
      } = dataStreamStat;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
        integration: integration
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, title), showFullDatasetNames && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("em", null, name)));
    }
  }, {
    name: namespaceColumnName,
    field: 'namespace',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, dataStreamStat.namespace),
    width: '160px'
  }, {
    name: sizeColumnName,
    field: 'sizeBytes',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "60px",
      height: "20px",
      borderRadius: "m",
      isLoading: loadingDataStreamStats
    }, (0, _formatters.formatBytes)(dataStreamStat.sizeBytes || 0)),
    width: '100px'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: degradedDocsColumnTooltip
    }, /*#__PURE__*/_react.default.createElement("span", null, `${degradedDocsColumnName} `, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    field: 'degradedDocs.percentage',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_degraded_docs_percentage_link.DegradedDocsPercentageLink, {
      isLoading: loadingDegradedStats,
      dataStreamStat: dataStreamStat
    }),
    width: '140px'
  }, {
    name: lastActivityColumnName,
    field: 'lastActivity',
    render: timestamp => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "200px",
      height: "20px",
      borderRadius: "m",
      isLoading: loadingDataStreamStats
    }, !isActiveDataset(timestamp) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, inactiveDatasetActivityColumnDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: inactiveDatasetActivityColumnTooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      tabIndex: 0,
      type: "iInCircle",
      size: "s"
    }))) : fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]).convert(timestamp)),
    width: '300px',
    sortable: true
  }, {
    name: actionsColumnName,
    render: dataStreamStat => /*#__PURE__*/_react.default.createElement(LogsExplorerLink, {
      dataStreamStat: dataStreamStat,
      title: openActionName
    }),
    width: '100px'
  }];
};
exports.getDatasetQualityTableColumns = getDatasetQualityTableColumns;
const LogsExplorerLink = ({
  dataStreamStat,
  title
}) => {
  const logsExplorerLinkProps = (0, _hooks.useLinkToLogsExplorer)({
    dataStreamStat
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "datasetQualityLogsExplorerLinkLink"
  }, logsExplorerLinkProps), title);
};