"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFieldStatsTableWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _stats_table = require("../../../common/components/stats_table");
var _index_data_visualizer_view = require("../../components/index_data_visualizer_view/index_data_visualizer_view");
var _index_based_expanded_row = require("../../../common/components/expanded_row/index_based_expanded_row");
var _use_data_visualizer_grid_data = require("../../hooks/use_data_visualizer_grid_data");
var _embeddable_field_stats_no_results = require("./embeddable_field_stats_no_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const restorableDefaults = (0, _index_data_visualizer_view.getDefaultDataVisualizerListState)();
const EmbeddableFieldStatsTableWrapper = ({
  input,
  onOutputChange
}) => {
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _react.useState)(restorableDefaults);
  const onTableChange = (0, _react.useCallback)(update => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      ...update
    });
    if (onOutputChange) {
      onOutputChange(update);
    }
  }, [dataVisualizerListState, onOutputChange]);
  const {
    configs,
    searchQueryLanguage,
    searchString,
    extendedColumns,
    progress,
    overallStatsProgress,
    setLastRefresh
  } = (0, _use_data_visualizer_grid_data.useDataVisualizerGridData)(input, dataVisualizerListState);
  (0, _react.useEffect)(() => {
    setLastRefresh(Date.now());
  }, [input === null || input === void 0 ? void 0 : input.lastReloadRequestTime, setLastRefresh]);
  const getItemIdToExpandedRowMap = (0, _react.useCallback)(function (itemIds, items) {
    return itemIds.reduce((m, fieldName) => {
      const item = items.find(fieldVisConfig => fieldVisConfig.fieldName === fieldName);
      if (item !== undefined) {
        m[fieldName] = /*#__PURE__*/_react.default.createElement(_index_based_expanded_row.IndexBasedDataVisualizerExpandedRow, {
          item: item,
          dataView: input.dataView,
          combinedQuery: {
            searchQueryLanguage,
            searchString
          },
          onAddFilter: input.onAddFilter,
          totalDocuments: input.totalDocuments
        });
      }
      return m;
    }, {});
  }, [input, searchQueryLanguage, searchString]);
  if (progress === 100 && configs.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_embeddable_field_stats_no_results.EmbeddableNoResultsEmptyPrompt, null);
  }
  return /*#__PURE__*/_react.default.createElement(_stats_table.DataVisualizerTable, {
    items: configs,
    pageState: dataVisualizerListState,
    updatePageState: onTableChange,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    extendedColumns: extendedColumns,
    showPreviewByDefault: input === null || input === void 0 ? void 0 : input.showPreviewByDefault,
    onChange: onOutputChange,
    loading: progress < 100,
    overallStatsRunning: overallStatsProgress.isRunning
  });
};
exports.EmbeddableFieldStatsTableWrapper = EmbeddableFieldStatsTableWrapper;