"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventRateChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _axes = require("./axes");
var _use_current_eui_theme = require("../../../common/hooks/use_current_eui_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EventRateChart = ({
  eventRateChartData,
  height,
  width
}) => {
  const {
    euiColorLightShade
  } = (0, _use_current_eui_theme.useCurrentEuiTheme)();
  const theme = {
    scales: {
      histogramPadding: 0.2
    },
    background: {
      color: 'transparent'
    },
    axes: {
      gridLine: {
        horizontal: {
          stroke: euiColorLightShade
        },
        vertical: {
          stroke: euiColorLightShade
        }
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width,
      height
    },
    "data-test-subj": `dataVisualizerEventRateChart ${eventRateChartData.length ? 'withData' : 'empty'}`
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_axes.Axes, null), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: "event_rate",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'time',
    yAccessors: ['value'],
    data: eventRateChartData,
    color: _uiTheme.euiLightVars.euiColorVis0
  })));
};
exports.EventRateChart = EventRateChart;