"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSUPPORTED_LABEL = exports.REFERENCE_LABEL = exports.NUMERIC_TYPE_LABEL = exports.DRIFT_P_VALUE_THRESHOLD = exports.DATA_COMPARISON_TYPE_LABEL = exports.DATA_COMPARISON_TYPE = exports.COMPARISON_LABEL = exports.CATEGORICAL_TYPE_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_COMPARISON_TYPE = exports.DATA_COMPARISON_TYPE = {
  NUMERIC: 'numeric',
  CATEGORICAL: 'categorical',
  UNSUPPORTED: 'unsupported'
};
const NUMERIC_TYPE_LABEL = exports.NUMERIC_TYPE_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.numericLabel', {
  defaultMessage: 'Numeric'
});
const CATEGORICAL_TYPE_LABEL = exports.CATEGORICAL_TYPE_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.categoricalLabel', {
  defaultMessage: 'Categorical'
});
const UNSUPPORTED_LABEL = exports.UNSUPPORTED_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.UnsupportedLabel', {
  defaultMessage: 'Unsupported'
});
const REFERENCE_LABEL = exports.REFERENCE_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.referenceLabel', {
  defaultMessage: 'Reference'
});
const COMPARISON_LABEL = exports.COMPARISON_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.comparisonLabel', {
  defaultMessage: 'Comparison'
});
const DATA_COMPARISON_TYPE_LABEL = exports.DATA_COMPARISON_TYPE_LABEL = {
  [DATA_COMPARISON_TYPE.NUMERIC]: NUMERIC_TYPE_LABEL,
  [DATA_COMPARISON_TYPE.CATEGORICAL]: CATEGORICAL_TYPE_LABEL,
  [DATA_COMPARISON_TYPE.UNSUPPORTED]: UNSUPPORTED_LABEL
};
const DRIFT_P_VALUE_THRESHOLD = exports.DRIFT_P_VALUE_THRESHOLD = 0.05;