"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActions = getActions;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _lens_utils = require("./lens_utils");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getActions(dataView, services, combinedQuery, dataViewEditorRef) {
  var _data$query$filterMan, _services$application, _services$application2, _services$application3, _services$application4, _services$application5, _services$application6;
  const {
    lens: lensPlugin,
    maps: mapsPlugin,
    data
  } = services;
  const actions = [];
  const filters = (_data$query$filterMan = data === null || data === void 0 ? void 0 : data.query.filterManager.getFilters()) !== null && _data$query$filterMan !== void 0 ? _data$query$filterMan : [];
  const refreshPage = () => {
    const refresh = {
      lastRefresh: Date.now()
    };
    _mlDatePicker.mlTimefilterRefresh$.next(refresh);
  };
  // Navigate to Lens with prefilled chart for data field
  if (((_services$application = services.application) === null || _services$application === void 0 ? void 0 : (_services$application2 = _services$application.capabilities) === null || _services$application2 === void 0 ? void 0 : (_services$application3 = _services$application2.visualize) === null || _services$application3 === void 0 ? void 0 : _services$application3.show) === true && lensPlugin !== undefined) {
    const canUseLensEditor = lensPlugin === null || lensPlugin === void 0 ? void 0 : lensPlugin.canUseEditor();
    actions.push({
      name: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.exploreInLensTitle', {
        defaultMessage: 'Explore in Lens'
      }),
      description: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.exploreInLensDescription', {
        defaultMessage: 'Explore in Lens'
      }),
      type: 'icon',
      icon: 'lensApp',
      available: item => (0, _lens_utils.getCompatibleLensDataType)(item.type) !== undefined && canUseLensEditor,
      onClick: item => {
        const lensAttributes = (0, _lens_utils.getLensAttributes)(dataView, combinedQuery, filters, item);
        if (lensAttributes) {
          lensPlugin.navigateToPrefilledEditor({
            id: `dataVisualizer-${item.fieldName}`,
            attributes: lensAttributes
          });
        }
      },
      'data-test-subj': 'dataVisualizerActionViewInLensButton'
    });
  }
  if (services !== null && services !== void 0 && services.uiActions && mapsPlugin && ((_services$application4 = services.application) === null || _services$application4 === void 0 ? void 0 : (_services$application5 = _services$application4.capabilities) === null || _services$application5 === void 0 ? void 0 : (_services$application6 = _services$application5.maps) === null || _services$application6 === void 0 ? void 0 : _services$application6.show) === true) {
    actions.push({
      name: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.exploreInMapsTitle', {
        defaultMessage: 'Explore in Maps'
      }),
      description: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.exploreInMapsDescription', {
        defaultMessage: 'Explore in Maps'
      }),
      type: 'icon',
      icon: 'gisApp',
      available: item => {
        return item.type === _constants.SUPPORTED_FIELD_TYPES.GEO_POINT || item.type === _constants.SUPPORTED_FIELD_TYPES.GEO_SHAPE;
      },
      onClick: async item => {
        if (services !== null && services !== void 0 && services.uiActions && dataView) {
          const triggerOptions = {
            dataViewSpec: dataView.toSpec(),
            fieldName: item.fieldName,
            contextualFields: [],
            originatingApp: _constants.APP_ID
          };
          const testActions = await (services === null || services === void 0 ? void 0 : services.uiActions.getTriggerCompatibleActions(_public.VISUALIZE_GEO_FIELD_TRIGGER, triggerOptions));
          if (testActions.length > 0 && testActions[0] !== undefined) {
            services === null || services === void 0 ? void 0 : services.uiActions.getTrigger(_public.VISUALIZE_GEO_FIELD_TRIGGER).exec(triggerOptions);
          }
        }
      },
      'data-test-subj': 'dataVisualizerActionViewInMapsButton'
    });
  }
  if (dataViewEditorRef !== undefined) {
    var _services$dataViewFie;
    // Allow to edit data view field
    if ((_services$dataViewFie = services.dataViewFieldEditor) !== null && _services$dataViewFie !== void 0 && _services$dataViewFie.userPermissions.editIndexPattern()) {
      actions.push({
        name: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.editDataViewFieldTitle', {
          defaultMessage: 'Edit data view field'
        }),
        description: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.editDataViewFieldDescription', {
          defaultMessage: 'Edit data view field'
        }),
        type: 'icon',
        icon: 'indexEdit',
        onClick: item => {
          var _services$dataViewFie2;
          dataViewEditorRef.current = (_services$dataViewFie2 = services.dataViewFieldEditor) === null || _services$dataViewFie2 === void 0 ? void 0 : _services$dataViewFie2.openEditor({
            ctx: {
              dataView
            },
            fieldName: item.fieldName,
            onSave: refreshPage
          });
        },
        'data-test-subj': 'dataVisualizerActionEditIndexPatternFieldButton'
      });
      actions.push({
        name: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.deleteDataViewFieldTitle', {
          defaultMessage: 'Delete data view field'
        }),
        description: _i18n.i18n.translate('xpack.dataVisualizer.index.dataGrid.deleteIndexPatternFieldDescription', {
          defaultMessage: 'Delete data view field'
        }),
        type: 'icon',
        icon: 'trash',
        available: item => {
          return item.deletable === true;
        },
        onClick: item => {
          var _services$dataViewFie3;
          dataViewEditorRef.current = (_services$dataViewFie3 = services.dataViewFieldEditor) === null || _services$dataViewFie3 === void 0 ? void 0 : _services$dataViewFie3.openDeleteModal({
            ctx: {
              dataView
            },
            fieldName: item.fieldName,
            onDelete: refreshPage
          });
        },
        'data-test-subj': 'dataVisualizerActionDeleteIndexPatternFieldButton'
      });
    }
  }
  return actions;
}