"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexBasedDataVisualizerExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_expanded_row_css = require("./use_expanded_row_css");
var _geo_point_content_with_map = require("./geo_point_content_with_map");
var _constants = require("../../../../../common/constants");
var _field_data_expanded_row = require("../stats_table/components/field_data_expanded_row");
var _not_in_docs_content = require("../not_in_docs_content");
var _loading_indicator = require("../loading_indicator");
var _error_message = require("../stats_table/components/field_data_expanded_row/error_message");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexBasedDataVisualizerExpandedRow = ({
  item,
  dataView,
  combinedQuery,
  onAddFilter,
  esql,
  totalDocuments,
  timeFieldName,
  typeAccessor = 'type'
}) => {
  const config = {
    ...item,
    stats: {
      ...item.stats,
      totalDocuments
    }
  };
  const {
    loading,
    existsInDocs,
    fieldName
  } = config;
  const type = config[typeAccessor];
  const dvExpandedRow = (0, _use_expanded_row_css.useExpandedRowCss)();
  function getCardContent() {
    var _config$stats;
    if (existsInDocs === false) {
      return /*#__PURE__*/_react.default.createElement(_not_in_docs_content.NotInDocsContent, null);
    }
    if ((_config$stats = config.stats) !== null && _config$stats !== void 0 && _config$stats.error) {
      var _config$stats2;
      return /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessageContent, {
        fieldName: fieldName,
        error: (_config$stats2 = config.stats) === null || _config$stats2 === void 0 ? void 0 : _config$stats2.error
      });
    }
    switch (type) {
      case _constants.SUPPORTED_FIELD_TYPES.NUMBER:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.NumberContent, {
          config: config,
          onAddFilter: onAddFilter
        });
      case _constants.SUPPORTED_FIELD_TYPES.BOOLEAN:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.BooleanContent, {
          config: config,
          onAddFilter: onAddFilter
        });
      case _constants.SUPPORTED_FIELD_TYPES.DATE:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.DateContent, {
          config: config
        });
      case _constants.SUPPORTED_FIELD_TYPES.GEO_POINT:
      case _constants.SUPPORTED_FIELD_TYPES.GEO_SHAPE:
        return /*#__PURE__*/_react.default.createElement(_geo_point_content_with_map.GeoPointContentWithMap, {
          config: config,
          dataView: dataView,
          combinedQuery: combinedQuery,
          esql: esql,
          timeFieldName: timeFieldName
        });
      case _constants.SUPPORTED_FIELD_TYPES.IP:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.IpContent, {
          config: config,
          onAddFilter: onAddFilter
        });
      case _constants.SUPPORTED_FIELD_TYPES.KEYWORD:
      case _constants.SUPPORTED_FIELD_TYPES.VERSION:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.KeywordContent, {
          config: config,
          onAddFilter: onAddFilter
        });
      case _constants.SUPPORTED_FIELD_TYPES.TEXT:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.TextContent, {
          config: config
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.OtherContent, {
          config: config
        });
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: dvExpandedRow,
    "data-test-subj": `dataVisualizerFieldExpandedRow-${fieldName}`
  }, loading === true ? /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, null) : getCardContent());
};
exports.IndexBasedDataVisualizerExpandedRow = IndexBasedDataVisualizerExpandedRow;