"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = exports.IPM_APP_ID = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

const sectionsHeader = _i18n.i18n.translate('indexPatternManagement.dataView.sectionsHeader', {
  defaultMessage: 'Data Views'
});
const IPM_APP_ID = exports.IPM_APP_ID = 'dataViews';
class IndexPatternManagementPlugin {
  constructor(initializerContext) {}
  setup(core, {
    management,
    urlForwarding,
    ...deps
  }) {
    const kibanaSection = management.sections.section.kibana;
    if (!kibanaSection) {
      throw new Error('`kibana` management section not found.');
    }
    const newAppPath = `management/kibana/${IPM_APP_ID}`;
    const legacyPatternsPath = 'management/kibana/index_patterns';
    urlForwarding.forwardApp('management/kibana/index_pattern', newAppPath, path => '/create');
    urlForwarding.forwardApp(legacyPatternsPath, newAppPath, path => {
      const pathInApp = path.substr(legacyPatternsPath.length + 1);
      return pathInApp && `/patterns${pathInApp}`;
    });
    kibanaSection.registerApp({
      id: IPM_APP_ID,
      title: sectionsHeader,
      order: 0,
      capabilitiesId: 'indexPatterns',
      redirectFrom: 'kibana/indexPatterns',
      mount: async params => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_app')));
        return mountManagementSection(core.getStartServices, deps, params);
      }
    });
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;