"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const readOnlyBadge = {
  text: _i18n.i18n.translate('indexPatternManagement.indexPatterns.badge.readOnly.text', {
    defaultMessage: 'Read only'
  }),
  tooltip: _i18n.i18n.translate('indexPatternManagement.dataViews.badge.readOnly.tooltip', {
    defaultMessage: 'Unable to save data views'
  }),
  iconType: 'glasses'
};
async function mountManagementSection(getStartServices, {
  noDataPage
}, params) {
  const [{
    application,
    chrome,
    uiSettings,
    settings,
    notifications,
    overlays,
    http,
    docLinks,
    theme,
    i18n: coreI18n
  }, {
    data,
    dataViewFieldEditor,
    dataViewEditor,
    dataViews,
    fieldFormats,
    unifiedSearch,
    spaces,
    savedObjectsManagement
  }, indexPatternManagementStart] = await getStartServices();
  const canSave = dataViews.getCanSaveSync();
  if (!canSave) {
    chrome.setBadge(readOnlyBadge);
  }
  const deps = {
    application,
    chrome,
    uiSettings,
    settings,
    notifications,
    overlays,
    unifiedSearch,
    http,
    docLinks,
    data,
    dataViewFieldEditor,
    dataViews,
    indexPatternManagementStart: indexPatternManagementStart,
    setBreadcrumbs: params.setBreadcrumbs,
    fieldFormatEditors: dataViewFieldEditor.fieldFormatEditors,
    IndexPatternEditor: dataViewEditor.IndexPatternEditorComponent,
    fieldFormats,
    spaces: spaces !== null && spaces !== void 0 && spaces.hasOnlyDefaultSpace ? undefined : spaces,
    theme,
    savedObjectsManagement,
    noDataPage
  };
  const editPath = '/dataView/:id/field/:fieldName';
  const createPath = '/dataView/:id/create-field/';
  const createEditPath = dataViews.scriptedFieldsEnabled ? [editPath, createPath] : [editPath];
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
    theme: theme,
    i18n: coreI18n
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: deps
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: params.history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/create']
  }, /*#__PURE__*/_react.default.createElement(_components.IndexPatternTableWithRouter, {
    canSave: canSave,
    showCreateDialog: true
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: createEditPath
  }, /*#__PURE__*/_react.default.createElement(_components.CreateEditFieldContainer, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/dataView/:id']
  }, /*#__PURE__*/_react.default.createElement(_components.EditIndexPatternContainer, null)), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    path: '/patterns*',
    to: 'dataView*'
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/']
  }, /*#__PURE__*/_react.default.createElement(_components.IndexPatternTableWithRouter, {
    canSave: canSave
  })))))), params.element);
  return () => {
    chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(params.element);
  };
}