"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutPanelContext = exports.Panel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _flyout_panels = require("./flyout_panels");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const flyoutPanelContext = /*#__PURE__*/(0, _react.createContext)({
  registerFooter: () => {},
  registerContent: () => {}
});
const Panel = ({
  children,
  width,
  className = '',
  backgroundColor,
  border,
  'data-test-subj': dataTestSubj,
  ...rest
}) => {
  const [config, setConfig] = (0, _react.useState)({
    hasContent: false,
    hasFooter: false
  });
  const [styles, setStyles] = (0, _react.useState)({});
  const classes = (0, _classnames.default)('fieldEditor__flyoutPanel', className, {
    'fieldEditor__flyoutPanel--pageBackground': backgroundColor === 'euiPageBackground',
    'fieldEditor__flyoutPanel--emptyShade': backgroundColor === 'euiEmptyShade',
    'fieldEditor__flyoutPanel--leftBorder': border === 'left',
    'fieldEditor__flyoutPanel--rightBorder': border === 'right',
    'fieldEditor__flyoutPanel--withContent': config.hasContent
  });
  const {
    addPanel
  } = (0, _flyout_panels.useFlyoutPanelsContext)();
  const registerContent = (0, _react.useCallback)(() => {
    setConfig(prev => {
      return {
        ...prev,
        hasContent: true
      };
    });
  }, []);
  const registerFooter = (0, _react.useCallback)(() => {
    setConfig(prev => {
      if (!prev.hasContent) {
        throw new Error('You need to add a <FlyoutPanels.Content /> when you add a <FlyoutPanels.Footer />');
      }
      return {
        ...prev,
        hasFooter: true
      };
    });
  }, []);
  const ctx = (0, _react.useMemo)(() => ({
    registerContent,
    registerFooter
  }), [registerFooter, registerContent]);
  (0, _react.useLayoutEffect)(() => {
    const {
      removePanel,
      isFixedWidth
    } = addPanel({
      width
    });
    if (width) {
      setStyles(prev => {
        if (isFixedWidth) {
          return {
            ...prev,
            width: `${width}px`
          };
        }
        return {
          ...prev,
          minWidth: `${width}%`
        };
      });
    }
    return removePanel;
  }, [width, addPanel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "fieldEditor__flyoutPanels__column",
    style: styles,
    grow: false,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(flyoutPanelContext.Provider, {
    value: ctx
  }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), children)));
};
exports.Panel = Panel;
const useFlyoutPanelContext = () => {
  const ctx = (0, _react.useContext)(flyoutPanelContext);
  if (ctx === undefined) {
    throw new Error('useFlyoutPanel() must be used within a <flyoutPanelContext.Provider />');
  }
  return ctx;
};
exports.useFlyoutPanelContext = useFlyoutPanelContext;