"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateNanosFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _default = require("../default/default");
var _constants = require("./constants");
var _samples = require("../../samples");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DateNanosFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ..._default.defaultState,
      sampleInputs: ['2015-01-01T12:10:30.123456789Z', '2019-05-08T06:55:21.567891234Z', '2019-08-06T17:22:30.987654321Z']
    });
  }
  render() {
    const {
      format,
      formatParams
    } = this.props;
    const {
      error,
      samples
    } = this.state;
    const defaultPattern = `${format.getParamDefaults().pattern}`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.date.momentLabel",
        defaultMessage: "Moment.js format pattern (Default: {defaultPattern})",
        values: {
          defaultPattern: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, defaultPattern)
        }
      }),
      isInvalid: !!error,
      error: error,
      helpText: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: "https://momentjs.com/"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.date.documentationLabel",
        defaultMessage: "Documentation"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "link"
      })))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "dateEditorPattern",
      value: formatParams.pattern,
      placeholder: defaultPattern,
      onChange: e => {
        this.onChange({
          pattern: e.target.value
        });
      },
      isInvalid: !!error
    })), /*#__PURE__*/_react.default.createElement(_samples.FormatEditorSamples, {
      samples: samples
    }));
  }
}
exports.DateNanosFormatEditor = DateNanosFormatEditor;
(0, _defineProperty2.default)(DateNanosFormatEditor, "formatId", _constants.formatId);