"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTimeFields = extractTimeFields;
exports.noTimeFieldValue = exports.noTimeFieldLabel = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const noTimeFieldLabel = exports.noTimeFieldLabel = _i18n.i18n.translate('indexPatternEditor.createIndexPattern.stepTime.noTimeFieldOptionLabel', {
  defaultMessage: "--- I don't want to use the time filter ---"
});
const noTimeFieldValue = exports.noTimeFieldValue = '';
function extractTimeFields(fields, requireTimestampField = false) {
  const dateFields = fields.filter(field => field.type === 'date');
  if (dateFields.length === 0) {
    return [];
  }
  const noTimeFieldOption = {
    display: noTimeFieldLabel,
    fieldName: noTimeFieldValue
  };
  const timeFields = dateFields.map(field => ({
    display: field.name,
    fieldName: field.name
  }));
  if (!requireTimestampField) {
    timeFields.push(noTimeFieldOption);
  }
  return timeFields;
}