"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOUR_TAKING_TOO_LONG_STEP_KEY = exports.TOUR_RESTORE_STEP_KEY = void 0;
exports.useSearchSessionTour = useSearchSessionTour;
var _react = require("react");
var _lodash = require("lodash");
var _search_session_state = require("../../search_session_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TOUR_TAKING_TOO_LONG_TIMEOUT = 10000;
const TOUR_TAKING_TOO_LONG_STEP_KEY = exports.TOUR_TAKING_TOO_LONG_STEP_KEY = `data.searchSession.tour.takingTooLong`;
const TOUR_RESTORE_STEP_KEY = exports.TOUR_RESTORE_STEP_KEY = `data.searchSession.tour.restore`;
function useSearchSessionTour(storage, searchSessionIndicatorRef, state, searchSessionsDisabled, disableSearchSessionsTour, usageCollector) {
  const markOpenedDone = (0, _react.useCallback)(() => {
    safeSet(storage, TOUR_TAKING_TOO_LONG_STEP_KEY);
  }, [storage]);
  const markRestoredDone = (0, _react.useCallback)(() => {
    safeSet(storage, TOUR_RESTORE_STEP_KEY);
  }, [storage]);

  // Makes sure `trackSessionIndicatorTourLoading` is called only once per sessionId
  // if to call `usageCollector?.trackSessionIndicatorTourLoading()` directly inside the `useEffect` below
  // it might happen that we cause excessive logging
  // ESLint: React Hook useCallback received a function whose dependencies are unknown. Pass an inline function instead.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const trackSessionIndicatorTourLoading = (0, _react.useCallback)((0, _lodash.once)(() => usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackSessionIndicatorTourLoading()), [usageCollector, state]);

  // Makes sure `trackSessionIndicatorTourRestored` is called only once per sessionId
  // if to call `usageCollector?.trackSessionIndicatorTourRestored()` directly inside the `useEffect` below
  // it might happen that we cause excessive logging
  // ESLint: React Hook useCallback received a function whose dependencies are unknown. Pass an inline function instead.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const trackSessionIndicatorTourRestored = (0, _react.useCallback)((0, _lodash.once)(() => usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.trackSessionIndicatorTourRestored()), [usageCollector, state]);
  (0, _react.useEffect)(() => {
    if (searchSessionsDisabled) return;
    if (disableSearchSessionsTour) return;
    if (!searchSessionIndicatorRef) return;
    let timeoutHandle;
    if (state === _search_session_state.SearchSessionState.Loading) {
      if (!safeHas(storage, TOUR_TAKING_TOO_LONG_STEP_KEY)) {
        timeoutHandle = window.setTimeout(() => {
          trackSessionIndicatorTourLoading();
          searchSessionIndicatorRef.openPopover();
        }, TOUR_TAKING_TOO_LONG_TIMEOUT);
      }
    }
    if (state === _search_session_state.SearchSessionState.Restored) {
      if (!safeHas(storage, TOUR_RESTORE_STEP_KEY)) {
        trackSessionIndicatorTourRestored();
        searchSessionIndicatorRef.openPopover();
      }
    }
    return () => {
      clearTimeout(timeoutHandle);
    };
  }, [storage, searchSessionIndicatorRef, state, searchSessionsDisabled, disableSearchSessionsTour, markOpenedDone, markRestoredDone, usageCollector, trackSessionIndicatorTourRestored, trackSessionIndicatorTourLoading]);
  return {
    markOpenedDone,
    markRestoredDone
  };
}
function safeHas(storage, key) {
  try {
    return Boolean(storage.get(key));
  } catch (e) {
    return true;
  }
}
function safeSet(storage, key) {
  try {
    storage.set(key, true);
  } catch (e) {
    return true;
  }
}