"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_VALUE_CLICK = void 0;
exports.createValueClickActionDefinition = createValueClickActionDefinition;
var _triggers = require("../triggers");
var _create_filters_from_value_click = require("./filters/create_filters_from_value_click");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_VALUE_CLICK = exports.ACTION_VALUE_CLICK = 'ACTION_VALUE_CLICK';
function createValueClickActionDefinition(getStartServices) {
  return {
    type: ACTION_VALUE_CLICK,
    id: ACTION_VALUE_CLICK,
    shouldAutoExecute: async () => true,
    isCompatible: async context => {
      const filters = await (0, _create_filters_from_value_click.createFiltersFromValueClickAction)(context.data);
      return filters.length > 0;
    },
    execute: async context => {
      try {
        const filters = await (0, _create_filters_from_value_click.createFiltersFromValueClickAction)(context.data);
        if (filters.length > 0) {
          await getStartServices().uiActions.getTrigger(_triggers.APPLY_FILTER_TRIGGER).exec({
            filters,
            embeddable: context.embeddable,
            timeFieldName: context.data.timeFieldName
          });
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(`Error [ACTION_EMIT_APPLY_FILTER_TRIGGER]: can\'t extract filters from action context`);
      }
    }
  };
}