"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ipPrefixFunction = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ipPrefixFunction = exports.ipPrefixFunction = {
  name: 'ipPrefix',
  type: 'ip_prefix',
  inputTypes: ['null'],
  help: _i18n.i18n.translate('data.search.functions.ipPrefix.help', {
    defaultMessage: 'Create an IP prefix'
  }),
  args: {
    prefixLength: {
      types: ['number'],
      help: _i18n.i18n.translate('data.search.functions.ipPrefix.prefixLength.help', {
        defaultMessage: 'Specify the length of the network prefix'
      })
    },
    isIpv6: {
      types: ['boolean'],
      help: _i18n.i18n.translate('data.search.functions.ipPrefix.isIpv6.help', {
        defaultMessage: 'Specify whether the prefix applies to IPv6 addresses'
      })
    }
  },
  fn(input, {
    prefixLength,
    isIpv6
  }) {
    return {
      type: 'ip_prefix',
      prefixLength,
      isIpv6
    };
  }
};