"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardContainer = exports.DashboardContainerContext = exports.DashboardContainer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _analytics = require("@kbn/analytics");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _ebtTools = require("@kbn/ebt-tools");
var _public = require("@kbn/embeddable-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _ = require("../..");
var _dashboard_container_references = require("../../../common/dashboard_container/persistable_state/dashboard_container_references");
var _dashboard_constants = require("../../dashboard_constants");
var _plugin_services = require("../../services/plugin_services");
var _panel_placement = require("../component/panel_placement");
var _place_new_panel_strategies = require("../component/panel_placement/place_new_panel_strategies");
var _dashboard_viewport = require("../component/viewport/dashboard_viewport");
var _dashboard_container_reducers = require("../state/dashboard_container_reducers");
var _dashboard_diffing_integration = require("../state/diffing/dashboard_diffing_integration");
var _api = require("./api");
var _duplicate_dashboard_panel = require("./api/duplicate_dashboard_panel");
var _dashboard_control_group_integration = require("./create/controls/dashboard_control_group_integration");
var _create_dashboard = require("./create/create_dashboard");
var _dashboard_container_factory = require("./dashboard_container_factory");
var _dashboard_app_strings = require("../../dashboard_app/_dashboard_app_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardContainerContext = exports.DashboardContainerContext = /*#__PURE__*/(0, _react.createContext)(null);
const useDashboardContainer = () => {
  const dashboard = (0, _react.useContext)(DashboardContainerContext);
  if (dashboard == null) {
    throw new Error('useDashboardContainer must be used inside DashboardContainerContext.');
  }
  return dashboard;
};
exports.useDashboardContainer = useDashboardContainer;
class DashboardContainer extends _public.Container {
  trackContentfulRender() {
    if (!this.hadContentfulRender && this.analyticsService) {
      this.analyticsService.reportEvent('dashboard_loaded_with_data', {});
    }
    this.hadContentfulRender = true;
  }
  constructor(initialInput, reduxToolsPackage, initialSessionId, dashboardCreationStartTime, parent, creationOptions, initialComponentState) {
    var _usageCollection$repo;
    const {
      usageCollection,
      embeddable: {
        getEmbeddableFactory
      }
    } = _plugin_services.pluginServices.getServices();
    super({
      ...initialInput
    }, {
      embeddableLoaded: {}
    }, getEmbeddableFactory, parent);
    (0, _defineProperty2.default)(this, "type", _.DASHBOARD_CONTAINER_TYPE);
    // state management
    (0, _defineProperty2.default)(this, "select", void 0);
    (0, _defineProperty2.default)(this, "getState", void 0);
    (0, _defineProperty2.default)(this, "dispatch", void 0);
    (0, _defineProperty2.default)(this, "onStateChange", void 0);
    (0, _defineProperty2.default)(this, "anyReducerRun", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "integrationSubscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "publishingSubscription", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "diffingSubscription", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "controlGroup", void 0);
    (0, _defineProperty2.default)(this, "settings", void 0);
    (0, _defineProperty2.default)(this, "searchSessionId", void 0);
    (0, _defineProperty2.default)(this, "lastReloadRequestTime$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "searchSessionId$", new _rxjs.BehaviorSubject(undefined));
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "timeRestore$", void 0);
    (0, _defineProperty2.default)(this, "timeslice$", void 0);
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "executionContext", void 0);
    // cleanup
    (0, _defineProperty2.default)(this, "stopSyncingWithUnifiedSearch", void 0);
    (0, _defineProperty2.default)(this, "cleanupStateTools", void 0);
    // performance monitoring
    (0, _defineProperty2.default)(this, "dashboardCreationStartTime", void 0);
    (0, _defineProperty2.default)(this, "domNode", void 0);
    (0, _defineProperty2.default)(this, "overlayRef", void 0);
    (0, _defineProperty2.default)(this, "allDataViews", []);
    (0, _defineProperty2.default)(this, "hadContentfulRender", false);
    // Services that are used in the Dashboard container code
    (0, _defineProperty2.default)(this, "creationOptions", void 0);
    (0, _defineProperty2.default)(this, "analyticsService", void 0);
    (0, _defineProperty2.default)(this, "showWriteControls", void 0);
    (0, _defineProperty2.default)(this, "theme$", void 0);
    (0, _defineProperty2.default)(this, "chrome", void 0);
    (0, _defineProperty2.default)(this, "customBranding", void 0);
    (0, _defineProperty2.default)(this, "trackPanelAddMetric", void 0);
    // new embeddable framework
    (0, _defineProperty2.default)(this, "savedObjectReferences", []);
    // ------------------------------------------------------------------------------------------------------
    // Dashboard API
    // ------------------------------------------------------------------------------------------------------
    (0, _defineProperty2.default)(this, "runClone", _api.runClone);
    (0, _defineProperty2.default)(this, "runSaveAs", _api.runSaveAs);
    (0, _defineProperty2.default)(this, "runQuickSave", _api.runQuickSave);
    (0, _defineProperty2.default)(this, "showSettings", _api.showSettings);
    (0, _defineProperty2.default)(this, "addFromLibrary", _api.addFromLibrary);
    (0, _defineProperty2.default)(this, "canRemovePanels", () => !this.getExpandedPanelId());
    (0, _defineProperty2.default)(this, "getTypeDisplayName", () => _dashboard_container_factory.dashboardTypeDisplayName);
    (0, _defineProperty2.default)(this, "getTypeDisplayNameLowerCase", () => _dashboard_container_factory.dashboardTypeDisplayLowercase);
    (0, _defineProperty2.default)(this, "savedObjectId", void 0);
    (0, _defineProperty2.default)(this, "expandedPanelId", void 0);
    (0, _defineProperty2.default)(this, "getDashboardPanelFromId", async panelId => {
      const panel = this.getInput().panels[panelId];
      if ((0, _public.reactEmbeddableRegistryHasKey)(panel.type)) {
        const child = this.children$.value[panelId];
        if (!child) throw new _public.PanelNotFoundError();
        const serialized = (0, _presentationContainers.apiHasSerializableState)(child) ? child.serializeState() : {
          rawState: {}
        };
        return {
          type: panel.type,
          explicitInput: {
            ...panel.explicitInput,
            ...serialized.rawState
          },
          gridData: panel.gridData,
          version: serialized.version
        };
      }
      return panel;
    });
    (0, _defineProperty2.default)(this, "expandPanel", panelId => {
      this.setExpandedPanelId(panelId);
      if (!panelId) {
        this.setScrollToPanelId(panelId);
      }
    });
    (0, _defineProperty2.default)(this, "addOrUpdateEmbeddable", _api.addOrUpdateEmbeddable);
    (0, _defineProperty2.default)(this, "onDataViewsUpdate$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "navigateToDashboard", async (newSavedObjectId, newCreationOptions) => {
      var _this$stopSyncingWith;
      this.integrationSubscriptions.unsubscribe();
      this.integrationSubscriptions = new _rxjs.Subscription();
      (_this$stopSyncingWith = this.stopSyncingWithUnifiedSearch) === null || _this$stopSyncingWith === void 0 ? void 0 : _this$stopSyncingWith.call(this);
      const {
        dashboardContentManagement: {
          loadDashboardState
        }
      } = _plugin_services.pluginServices.getServices();
      if (newCreationOptions) {
        this.creationOptions = {
          ...this.creationOptions,
          ...newCreationOptions
        };
      }
      const loadDashboardReturn = await loadDashboardState({
        id: newSavedObjectId
      });
      const dashboardContainerReady$ = new _rxjs.Subject();
      const untilDashboardReady = () => new Promise(resolve => {
        const subscription = dashboardContainerReady$.subscribe(container => {
          subscription.unsubscribe();
          resolve(container);
        });
      });
      const initializeResult = await (0, _create_dashboard.initializeDashboard)({
        creationOptions: this.creationOptions,
        controlGroup: this.controlGroup,
        untilDashboardReady,
        loadDashboardReturn
      });
      if (!initializeResult) return;
      const {
        input: newInput,
        searchSessionId
      } = initializeResult;
      this.searchSessionId = searchSessionId;
      this.searchSessionId$.next(searchSessionId);
      (0, _reactRedux.batch)(() => {
        this.dispatch.setLastSavedInput((0, _lodash.omit)(loadDashboardReturn === null || loadDashboardReturn === void 0 ? void 0 : loadDashboardReturn.dashboardInput, 'controlGroupInput'));
        this.dispatch.setManaged(loadDashboardReturn === null || loadDashboardReturn === void 0 ? void 0 : loadDashboardReturn.managed);
        if (this.controlGroup) {
          var _loadDashboardReturn$;
          this.controlGroup.setSavedState((_loadDashboardReturn$ = loadDashboardReturn.dashboardInput) === null || _loadDashboardReturn$ === void 0 ? void 0 : _loadDashboardReturn$.controlGroupInput);
        }
        this.dispatch.setAnimatePanelTransforms(false); // prevents panels from animating on navigate.
        this.dispatch.setLastSavedId(newSavedObjectId);
      });
      this.updateInput(newInput);
      dashboardContainerReady$.next(this);
    });
    /**
     * Gets all the dataviews that are actively being used in the dashboard
     * @returns An array of dataviews
     */
    (0, _defineProperty2.default)(this, "getAllDataViews", () => {
      return this.allDataViews;
    });
    /**
     * Use this to set the dataviews that are used in the dashboard when they change/update
     * @param newDataViews The new array of dataviews that will overwrite the old dataviews array
     */
    (0, _defineProperty2.default)(this, "setAllDataViews", newDataViews => {
      this.allDataViews = newDataViews;
      this.onDataViewsUpdate$.next(newDataViews);
    });
    (0, _defineProperty2.default)(this, "getExpandedPanelId", () => {
      return this.getState().componentState.expandedPanelId;
    });
    (0, _defineProperty2.default)(this, "setExpandedPanelId", newId => {
      this.dispatch.setExpandedPanelId(newId);
    });
    (0, _defineProperty2.default)(this, "openOverlay", (ref, options) => {
      this.clearOverlays();
      this.dispatch.setHasOverlays(true);
      this.overlayRef = ref;
      if (options !== null && options !== void 0 && options.focusedPanelId) {
        this.setFocusedPanelId(options === null || options === void 0 ? void 0 : options.focusedPanelId);
      }
    });
    (0, _defineProperty2.default)(this, "clearOverlays", () => {
      var _this$controlGroup, _this$overlayRef;
      this.dispatch.setHasOverlays(false);
      this.dispatch.setFocusedPanelId(undefined);
      (_this$controlGroup = this.controlGroup) === null || _this$controlGroup === void 0 ? void 0 : _this$controlGroup.closeAllFlyouts();
      (_this$overlayRef = this.overlayRef) === null || _this$overlayRef === void 0 ? void 0 : _this$overlayRef.close();
    });
    (0, _defineProperty2.default)(this, "getPanelCount", () => {
      return Object.keys(this.getInput().panels).length;
    });
    (0, _defineProperty2.default)(this, "setScrollToPanelId", id => {
      this.dispatch.setScrollToPanelId(id);
    });
    (0, _defineProperty2.default)(this, "scrollToPanel", async panelRef => {
      const id = this.getState().componentState.scrollToPanelId;
      if (!id) return;
      this.untilEmbeddableLoaded(id).then(() => {
        this.setScrollToPanelId(undefined);
        panelRef.scrollIntoView({
          block: 'center'
        });
      });
    });
    (0, _defineProperty2.default)(this, "scrollToTop", () => {
      window.scroll(0, 0);
    });
    (0, _defineProperty2.default)(this, "setHighlightPanelId", id => {
      this.dispatch.setHighlightPanelId(id);
    });
    (0, _defineProperty2.default)(this, "highlightPanel", panelRef => {
      const id = this.getState().componentState.highlightPanelId;
      if (id && panelRef) {
        this.untilEmbeddableLoaded(id).then(() => {
          panelRef.classList.add('dshDashboardGrid__item--highlighted');
          // Removes the class after the highlight animation finishes
          setTimeout(() => {
            panelRef.classList.remove('dshDashboardGrid__item--highlighted');
          }, 5000);
        });
      }
      this.setHighlightPanelId(undefined);
    });
    (0, _defineProperty2.default)(this, "setFocusedPanelId", id => {
      this.dispatch.setFocusedPanelId(id);
      this.setScrollToPanelId(id);
    });
    // ------------------------------------------------------------------------------------------------------
    // React Embeddable system
    // ------------------------------------------------------------------------------------------------------
    (0, _defineProperty2.default)(this, "registerChildApi", api => {
      this.children$.next({
        ...this.children$.value,
        [api.uuid]: api
      });
    });
    (0, _defineProperty2.default)(this, "lastSavedState", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "getLastSavedStateForChild", childId => {
      const {
        componentState: {
          lastSavedInput: {
            panels
          }
        }
      } = this.getState();
      const panel = panels[childId];
      const references = (0, _dashboard_container_references.getReferencesForPanelId)(childId, this.savedObjectReferences);
      return {
        rawState: panel === null || panel === void 0 ? void 0 : panel.explicitInput,
        version: panel === null || panel === void 0 ? void 0 : panel.version,
        references
      };
    });
    (0, _defineProperty2.default)(this, "startAuditingReactEmbeddableChildren", () => {
      const auditChildren = () => {
        const currentChildren = this.children$.value;
        let panelsChanged = false;
        for (const panelId of Object.keys(currentChildren)) {
          if (!this.getInput().panels[panelId]) {
            delete currentChildren[panelId];
            panelsChanged = true;
          }
        }
        if (panelsChanged) this.children$.next(currentChildren);
      };

      // audit children when panels change
      this.publishingSubscription.add(this.getInput$().pipe((0, _rxjs.map)(() => Object.keys(this.getInput().panels)), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)).subscribe(() => auditChildren()));
      auditChildren();
    });
    (0, _defineProperty2.default)(this, "resetAllReactEmbeddables", () => {
      let resetChangedPanelCount = false;
      const currentChildren = this.children$.value;
      for (const panelId of Object.keys(currentChildren)) {
        if (this.getInput().panels[panelId]) {
          const child = currentChildren[panelId];
          if ((0, _presentationPublishing.apiPublishesUnsavedChanges)(child)) child.resetUnsavedChanges();
        } else {
          // if reset resulted in panel removal, we need to update the list of children
          delete currentChildren[panelId];
          resetChangedPanelCount = true;
        }
      }
      if (resetChangedPanelCount) this.children$.next(currentChildren);
    });
    this.trackPanelAddMetric = (_usageCollection$repo = usageCollection.reportUiCounter) === null || _usageCollection$repo === void 0 ? void 0 : _usageCollection$repo.bind(usageCollection, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
    ({
      analytics: this.analyticsService,
      settings: {
        theme: {
          theme$: this.theme$
        }
      },
      chrome: this.chrome,
      customBranding: this.customBranding,
      dashboardCapabilities: {
        showWriteControls: this.showWriteControls
      }
    } = _plugin_services.pluginServices.getServices());
    this.creationOptions = creationOptions;
    this.searchSessionId = initialSessionId;
    this.searchSessionId$.next(initialSessionId);
    this.dashboardCreationStartTime = dashboardCreationStartTime;

    // start diffing dashboard state
    const diffingMiddleware = _dashboard_diffing_integration.getDiffingMiddleware.bind(this)();

    // build redux embeddable tools
    const reduxTools = reduxToolsPackage.createReduxEmbeddableTools({
      embeddable: this,
      reducers: _dashboard_container_reducers.dashboardContainerReducers,
      additionalMiddleware: [diffingMiddleware],
      initialComponentState
    });
    this.onStateChange = reduxTools.onStateChange;
    this.cleanupStateTools = reduxTools.cleanup;
    this.getState = reduxTools.getState;
    this.dispatch = reduxTools.dispatch;
    this.select = reduxTools.select;
    this.savedObjectId = new _rxjs.BehaviorSubject(this.getDashboardSavedObjectId());
    this.publishingSubscription.add(this.onStateChange(() => {
      if (this.savedObjectId.value === this.getDashboardSavedObjectId()) return;
      this.savedObjectId.next(this.getDashboardSavedObjectId());
    }));
    this.publishingSubscription.add(this.savedObjectId.subscribe(() => {
      this.hadContentfulRender = false;
    }));
    this.expandedPanelId = new _rxjs.BehaviorSubject(this.getDashboardSavedObjectId());
    this.publishingSubscription.add(this.onStateChange(() => {
      if (this.expandedPanelId.value === this.getExpandedPanelId()) return;
      this.expandedPanelId.next(this.getExpandedPanelId());
    }));
    this.startAuditingReactEmbeddableChildren();
    this.settings = {
      syncColors$: (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'syncColors'),
      syncCursor$: (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'syncCursor'),
      syncTooltips$: (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'syncTooltips')
    };
    this.timeRestore$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'timeRestore');
    this.timeslice$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'timeslice');
    this.lastReloadRequestTime$ = (0, _public.embeddableInputToSubject)(this.publishingSubscription, this, 'lastReloadRequestTime');
    this.executionContext = initialInput.executionContext;
  }
  getAppContext() {
    var _this$creationOptions, _this$creationOptions2, _embeddableAppContext;
    const embeddableAppContext = (_this$creationOptions = this.creationOptions) === null || _this$creationOptions === void 0 ? void 0 : (_this$creationOptions2 = _this$creationOptions.getEmbeddableAppContext) === null || _this$creationOptions2 === void 0 ? void 0 : _this$creationOptions2.call(_this$creationOptions, this.getDashboardSavedObjectId());
    return {
      ...embeddableAppContext,
      currentAppId: (_embeddableAppContext = embeddableAppContext === null || embeddableAppContext === void 0 ? void 0 : embeddableAppContext.currentAppId) !== null && _embeddableAppContext !== void 0 ? _embeddableAppContext : _dashboard_constants.DASHBOARD_APP_ID
    };
  }
  getDashboardSavedObjectId() {
    return this.getState().componentState.lastSavedId;
  }
  reportPerformanceMetrics(stats) {
    if (this.analyticsService && this.dashboardCreationStartTime) {
      const panelCount = Object.keys(this.getState().explicitInput.panels).length;
      const totalDuration = stats.panelsRenderDoneTime - this.dashboardCreationStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(this.analyticsService, {
        eventName: _dashboard_constants.DASHBOARD_LOADED_EVENT,
        duration: totalDuration,
        key1: 'time_to_data',
        value1: (stats.lastTimeToData || stats.panelsRenderDoneTime) - stats.panelsRenderStartTime,
        key2: 'num_of_panels',
        value2: panelCount,
        key3: 'total_load_time',
        value3: totalDuration
      });
    }
  }
  createNewPanelState(factory, partial = {}, attributes) {
    const {
      newPanel
    } = super.createNewPanelState(factory, partial, attributes);
    return (0, _panel_placement.placePanel)(factory, newPanel, this.input.panels, attributes);
  }
  render(dom) {
    if (this.domNode) {
      _reactDom.default.unmountComponentAtNode(this.domNode);
    }
    this.domNode = dom;
    this.domNode.className = 'dashboardContainer';
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButtonKibanaProvider, {
      coreStart: {
        chrome: this.chrome,
        customBranding: this.customBranding
      }
    }, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: this.theme$
    }, /*#__PURE__*/_react.default.createElement(DashboardContainerContext.Provider, {
      value: this
    }, /*#__PURE__*/_react.default.createElement(_dashboard_viewport.DashboardViewport, null))))), dom);
  }
  updateInput(changes) {
    var _changes$viewMode, _ViewMode$EDIT;
    // block the Dashboard from entering edit mode if this Dashboard is managed.
    if ((this.getState().componentState.managed || !this.showWriteControls) && ((_changes$viewMode = changes.viewMode) === null || _changes$viewMode === void 0 ? void 0 : _changes$viewMode.toLowerCase()) === ((_ViewMode$EDIT = _public.ViewMode.EDIT) === null || _ViewMode$EDIT === void 0 ? void 0 : _ViewMode$EDIT.toLowerCase())) {
      const {
        viewMode,
        ...rest
      } = changes;
      super.updateInput(rest);
      return;
    }
    super.updateInput(changes);
  }
  getInheritedInput(id) {
    var _panels$id, _panels$id$explicitIn;
    const {
      query,
      filters,
      viewMode,
      timeRange,
      timeslice,
      syncColors,
      syncTooltips,
      syncCursor,
      hidePanelTitles,
      refreshInterval,
      executionContext,
      panels
    } = this.input;
    let combinedFilters = filters;
    if (this.controlGroup) {
      combinedFilters = (0, _dashboard_control_group_integration.combineDashboardFiltersWithControlGroupFilters)(filters, this.controlGroup);
    }
    const hasCustomTimeRange = Boolean((_panels$id = panels[id]) === null || _panels$id === void 0 ? void 0 : (_panels$id$explicitIn = _panels$id.explicitInput) === null || _panels$id$explicitIn === void 0 ? void 0 : _panels$id$explicitIn.timeRange);
    return {
      searchSessionId: this.searchSessionId,
      refreshConfig: refreshInterval,
      filters: combinedFilters,
      hidePanelTitles,
      executionContext,
      syncTooltips,
      syncColors,
      syncCursor,
      viewMode,
      query,
      id,
      // do not pass any time information from dashboard to panel when panel has custom time range
      // to avoid confusing panel which timeRange should be used
      timeRange: hasCustomTimeRange ? undefined : timeRange,
      timeslice: hasCustomTimeRange ? undefined : timeslice
    };
  }

  // ------------------------------------------------------------------------------------------------------
  // Cleanup
  // ------------------------------------------------------------------------------------------------------
  destroy() {
    var _this$controlGroup2, _this$stopSyncingWith2;
    super.destroy();
    this.cleanupStateTools();
    (_this$controlGroup2 = this.controlGroup) === null || _this$controlGroup2 === void 0 ? void 0 : _this$controlGroup2.destroy();
    this.diffingSubscription.unsubscribe();
    this.publishingSubscription.unsubscribe();
    this.integrationSubscriptions.unsubscribe();
    (_this$stopSyncingWith2 = this.stopSyncingWithUnifiedSearch) === null || _this$stopSyncingWith2 === void 0 ? void 0 : _this$stopSyncingWith2.call(this);
    if (this.domNode) _reactDom.default.unmountComponentAtNode(this.domNode);
  }
  duplicatePanel(id) {
    _duplicate_dashboard_panel.duplicateDashboardPanel.bind(this)(id);
  }
  async replacePanel(idToRemove, {
    panelType,
    initialState
  }) {
    const newId = await this.replaceEmbeddable(idToRemove, initialState, panelType, true);
    if (this.getExpandedPanelId() !== undefined) {
      this.setExpandedPanelId(newId);
    }
    this.setHighlightPanelId(newId);
    return newId;
  }
  async addNewPanel(panelPackage, displaySuccessMessage) {
    const {
      notifications: {
        toasts
      },
      embeddable: {
        getEmbeddableFactory
      }
    } = _plugin_services.pluginServices.getServices();
    const onSuccess = (id, title) => {
      if (!displaySuccessMessage) return;
      toasts.addSuccess({
        title: (0, _dashboard_app_strings.getPanelAddedSuccessString)(title),
        'data-test-subj': 'addEmbeddableToDashboardSuccess'
      });
      this.setScrollToPanelId(id);
      this.setHighlightPanelId(id);
    };
    if (this.trackPanelAddMetric) {
      this.trackPanelAddMetric(_analytics.METRIC_TYPE.CLICK, panelPackage.panelType);
    }
    if ((0, _public.reactEmbeddableRegistryHasKey)(panelPackage.panelType)) {
      const newId = (0, _uuid.v4)();
      const {
        newPanelPlacement,
        otherPanels
      } = _place_new_panel_strategies.panelPlacementStrategies.findTopLeftMostOpenSpace({
        currentPanels: this.getInput().panels,
        height: _dashboard_constants.DEFAULT_PANEL_HEIGHT,
        width: _dashboard_constants.DEFAULT_PANEL_WIDTH
      });
      const newPanel = {
        type: panelPackage.panelType,
        gridData: {
          ...newPanelPlacement,
          i: newId
        },
        explicitInput: {
          ...panelPackage.initialState,
          id: newId
        }
      };
      this.updateInput({
        panels: {
          ...otherPanels,
          [newId]: newPanel
        }
      });
      onSuccess(newId, newPanel.explicitInput.title);
      return;
    }
    const embeddableFactory = getEmbeddableFactory(panelPackage.panelType);
    if (!embeddableFactory) {
      throw new _public.EmbeddableFactoryNotFoundError(panelPackage.panelType);
    }
    const initialInput = panelPackage.initialState;
    let explicitInput;
    let attributes;
    try {
      if (initialInput) {
        explicitInput = initialInput;
      } else {
        const explicitInputReturn = await embeddableFactory.getExplicitInput(undefined, this);
        if ((0, _public.isExplicitInputWithAttributes)(explicitInputReturn)) {
          explicitInput = explicitInputReturn.newInput;
          attributes = explicitInputReturn.attributes;
        } else {
          explicitInput = explicitInputReturn;
        }
      }
    } catch (e) {
      // error likely means user canceled embeddable creation
      return;
    }
    const newEmbeddable = await this.addNewEmbeddable(embeddableFactory.type, explicitInput, attributes);
    if (newEmbeddable) {
      onSuccess(newEmbeddable.id, newEmbeddable.getTitle());
    }
    return newEmbeddable;
  }
  forceRefresh(refreshControlGroup = true) {
    this.dispatch.setLastReloadRequestTimeToNow({});
    if (refreshControlGroup) {
      var _this$controlGroup3;
      (_this$controlGroup3 = this.controlGroup) === null || _this$controlGroup3 === void 0 ? void 0 : _this$controlGroup3.reload();

      // only reload all panels if this refresh does not come from the control group.
      this.reload$.next();
    }
  }
  resetToLastSavedState() {
    var _this$creationOptions3;
    this.dispatch.resetToLastSavedInput({});
    const {
      explicitInput: {
        timeRange,
        refreshInterval
      },
      componentState: {
        lastSavedInput: {
          timeRestore: lastSavedTimeRestore
        }
      }
    } = this.getState();
    if (this.controlGroup) {
      this.controlGroup.resetToLastSavedState();
    }

    // if we are using the unified search integration, we need to force reset the time picker.
    if ((_this$creationOptions3 = this.creationOptions) !== null && _this$creationOptions3 !== void 0 && _this$creationOptions3.useUnifiedSearchIntegration && lastSavedTimeRestore) {
      const {
        data: {
          query: {
            timefilter: {
              timefilter: timeFilterService
            }
          }
        }
      } = _plugin_services.pluginServices.getServices();
      if (timeRange) timeFilterService.setTime(timeRange);
      if (refreshInterval) timeFilterService.setRefreshInterval(refreshInterval);
    }
    this.resetAllReactEmbeddables();
  }
  async getPanelTitles() {
    const titles = [];
    for (const [id, panel] of Object.entries(this.getInput().panels)) {
      const title = await (async () => {
        if ((0, _public.reactEmbeddableRegistryHasKey)(panel.type)) {
          const child = this.children$.value[id];
          return (0, _presentationPublishing.apiPublishesPanelTitle)(child) ? (0, _presentationPublishing.getPanelTitle)(child) : '';
        }
        await this.untilEmbeddableLoaded(id);
        const child = this.getChild(id);
        if (!child) return undefined;
        return child.getTitle();
      })();
      if (title) titles.push(title);
    }
    return titles;
  }
  removePanel(id) {
    var _this$getInput$panels;
    const type = (_this$getInput$panels = this.getInput().panels[id]) === null || _this$getInput$panels === void 0 ? void 0 : _this$getInput$panels.type;
    this.removeEmbeddable(id);
    if ((0, _public.reactEmbeddableRegistryHasKey)(type)) {
      const {
        [id]: childToRemove,
        ...otherChildren
      } = this.children$.value;
      this.children$.next(otherChildren);
    }
  }
}
exports.DashboardContainer = DashboardContainer;