"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.placePanel = placePanel;
exports.providesPanelPlacementSettings = void 0;
var _place_new_panel_strategies = require("./place_new_panel_strategies");
var _dashboard_constants = require("../../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providesPanelPlacementSettings = value => {
  return Boolean(value.getPanelPlacementSettings);
};
exports.providesPanelPlacementSettings = providesPanelPlacementSettings;
function placePanel(factory, newPanel, currentPanels, attributes) {
  let placementSettings = {
    width: _dashboard_constants.DEFAULT_PANEL_WIDTH,
    height: _dashboard_constants.DEFAULT_PANEL_HEIGHT,
    strategy: 'findTopLeftMostOpenSpace'
  };
  if (providesPanelPlacementSettings(factory)) {
    placementSettings = {
      ...placementSettings,
      ...factory.getPanelPlacementSettings(newPanel.explicitInput, attributes)
    };
  }
  const {
    width,
    height,
    strategy
  } = placementSettings;
  const {
    newPanelPlacement,
    otherPanels
  } = _place_new_panel_strategies.panelPlacementStrategies[strategy]({
    currentPanels,
    height,
    width
  });
  return {
    newPanel: {
      gridData: {
        ...newPanelPlacement,
        i: newPanel.explicitInput.id
      },
      ...newPanel
    },
    otherPanels
  };
}