"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyAddToLibraryAction = exports.ACTION_LEGACY_ADD_TO_LIBRARY = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_LEGACY_ADD_TO_LIBRARY = exports.ACTION_LEGACY_ADD_TO_LIBRARY = 'legacySaveToLibrary';
const isApiCompatible = api => Boolean((0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasLegacyLibraryTransforms)(api));
class LegacyAddToLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_LEGACY_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "id", ACTION_LEGACY_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 15);
    (0, _defineProperty2.default)(this, "toastsService", void 0);
    ({
      notifications: {
        toasts: this.toastsService
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'folderCheck';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) return false;
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && (await embeddable.canLinkToLibrary());
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    const panelTitle = (0, _presentationPublishing.getPanelTitle)(embeddable);
    try {
      await embeddable.linkToLibrary();
      this.toastsService.addSuccess({
        title: _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getSuccessMessage(panelTitle ? `'${panelTitle}'` : ''),
        'data-test-subj': 'addPanelToLibrarySuccess'
      });
    } catch (e) {
      this.toastsService.addDanger({
        title: _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getErrorMessage(panelTitle),
        'data-test-subj': 'addPanelToLibraryError'
      });
    }
  }
}
exports.LegacyAddToLibraryAction = LegacyAddToLibraryAction;