"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersNotificationAction = exports.BADGE_FILTERS_NOTIFICATION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _plugin_services = require("../services/plugin_services");
var _filters_notification_popover = require("./filters_notification_popover");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BADGE_FILTERS_NOTIFICATION = exports.BADGE_FILTERS_NOTIFICATION = 'ACTION_FILTERS_NOTIFICATION';
const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiPublishesPartialUnifiedSearch)(api));
const compatibilityCheck = api => {
  var _api$query$, _api$filters$$value, _api$filters$;
  if (!isApiCompatible(api) || (0, _presentationPublishing.getInheritedViewMode)(api) !== 'edit') return false;
  const query = (_api$query$ = api.query$) === null || _api$query$ === void 0 ? void 0 : _api$query$.value;
  return ((_api$filters$$value = (_api$filters$ = api.filters$) === null || _api$filters$ === void 0 ? void 0 : _api$filters$.value) !== null && _api$filters$$value !== void 0 ? _api$filters$$value : []).length > 0 || (0, _esQuery.isOfQueryType)(query) && query.query !== '' || (0, _esQuery.isOfAggregateQueryType)(query);
};
class FiltersNotificationAction {
  constructor() {
    (0, _defineProperty2.default)(this, "id", BADGE_FILTERS_NOTIFICATION);
    (0, _defineProperty2.default)(this, "type", BADGE_FILTERS_NOTIFICATION);
    (0, _defineProperty2.default)(this, "order", 2);
    (0, _defineProperty2.default)(this, "settingsService", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      const {
        embeddable
      } = context;
      if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
      const {
        Provider: KibanaReactContextProvider
      } = (0, _public.createKibanaReactContext)({
        uiSettings: this.settingsService.uiSettings
      });
      return /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_filters_notification_popover.FiltersNotificationPopover, {
        api: embeddable
      }));
    });
    (0, _defineProperty2.default)(this, "isCompatible", async ({
      embeddable
    }) => {
      return compatibilityCheck(embeddable);
    });
    (0, _defineProperty2.default)(this, "execute", async () => {});
    ({
      settings: this.settingsService
    } = _plugin_services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardFilterNotificationActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return 'filter';
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return (0, _presentationPublishing.apiPublishesPartialUnifiedSearch)(embeddable);
  }
  subscribeToCompatibilityChanges({
    embeddable
  }, onChange) {
    if (!isApiCompatible(embeddable)) return;
    return (0, _rxjs.merge)(...[embeddable.query$, embeddable.filters$, (0, _presentationPublishing.getViewModeSubject)(embeddable)].filter(value => Boolean(value))).subscribe(() => onChange(compatibilityCheck(embeddable), this));
  }
}
exports.FiltersNotificationAction = FiltersNotificationAction;