"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternEdit = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("../../components");
var _constants = require("../../constants");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutoFollowPatternEdit extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      lastAutoFollowPatternId: undefined
    });
  }
  static getDerivedStateFromProps({
    autoFollowPatternId
  }, {
    lastAutoFollowPatternId
  }) {
    if (lastAutoFollowPatternId !== autoFollowPatternId) {
      return {
        lastAutoFollowPatternId: autoFollowPatternId
      };
    }
    return null;
  }
  componentDidMount() {
    const {
      match: {
        params: {
          id
        }
      },
      selectAutoFollowPattern
    } = this.props;
    const decodedId = decodeURIComponent(id);
    selectAutoFollowPattern(decodedId);
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)('/auto_follow_patterns'), _breadcrumbs.editBreadcrumb]);
  }
  componentDidUpdate(prevProps, prevState) {
    const {
      autoFollowPattern,
      getAutoFollowPattern
    } = this.props;
    // Fetch the auto-follow pattern on the server if we don't have it (i.e. page reload)
    if (!autoFollowPattern && prevState.lastAutoFollowPatternId !== this.state.lastAutoFollowPatternId) {
      getAutoFollowPattern(this.state.lastAutoFollowPatternId);
    }
  }
  componentWillUnmount() {
    this.props.clearApiError();
  }
  renderGetAutoFollowPatternError(error) {
    const {
      match: {
        params: {
          id: name
        }
      }
    } = this.props;
    const errorMessage = error.body.statusCode === 404 ? {
      error: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternEditForm.loadingErrorMessage', {
        defaultMessage: `The auto-follow pattern '{name}' does not exist.`,
        values: {
          name
        }
      })
    } : error;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternEditForm.loadingErrorTitle",
        defaultMessage: "Error loading auto-follow pattern"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, errorMessage),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, `/auto_follow_patterns`), {
        color: "danger",
        flush: "left",
        iconType: "arrowLeft",
        "data-test-subj": "viewAutoFollowPatternListButton"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternEditForm.viewAutoFollowPatternsButtonLabel",
        defaultMessage: "View auto-follow patterns"
      }))
    });
  }
  renderLoading(loadingTitle) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, loadingTitle);
  }
  render() {
    const {
      saveAutoFollowPattern,
      apiStatus,
      apiError,
      autoFollowPattern,
      match: {
        url: currentUrl
      }
    } = this.props;
    if (apiStatus.get === _constants.API_STATUS.LOADING || !autoFollowPattern) {
      return this.renderLoading(_i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternEditForm.loadingTitle', {
        defaultMessage: 'Loading auto-follow pattern…'
      }));
    }
    if (apiError.get) {
      return this.renderGetAutoFollowPatternError(apiError.get);
    }
    return /*#__PURE__*/_react.default.createElement(_components.RemoteClustersProvider, null, ({
      isLoading,
      error,
      remoteClusters
    }) => {
      if (isLoading) {
        return this.renderLoading(_i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternEditForm.loadingRemoteClustersMessage', {
          defaultMessage: 'Loading remote clusters…'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        restrictWidth: true,
        style: {
          width: '100%'
        }
      }, /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternPageTitle, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPattern.editTitle",
          defaultMessage: "Edit auto-follow pattern"
        })
      }), /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternForm, {
        apiStatus: apiStatus.save,
        apiError: apiError.save,
        currentUrl: currentUrl,
        remoteClusters: error ? [] : remoteClusters,
        autoFollowPattern: autoFollowPattern,
        saveAutoFollowPattern: saveAutoFollowPattern,
        saveButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternEditForm.saveButtonLabel",
          defaultMessage: "Update"
        })
      }));
    });
  }
}
exports.AutoFollowPatternEdit = AutoFollowPatternEdit;
(0, _defineProperty2.default)(AutoFollowPatternEdit, "propTypes", {
  getAutoFollowPattern: _propTypes.default.func.isRequired,
  selectAutoFollowPattern: _propTypes.default.func.isRequired,
  saveAutoFollowPattern: _propTypes.default.func.isRequired,
  clearApiError: _propTypes.default.func.isRequired,
  apiError: _propTypes.default.object.isRequired,
  apiStatus: _propTypes.default.object.isRequired,
  autoFollowPattern: _propTypes.default.object,
  autoFollowPatternId: _propTypes.default.string
});