"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_STATS_PREFIX = exports.RESOLVE_STATS_PREFIX = exports.RESOLVE_IMPORT_STATS_PREFIX = exports.LEGACY_DASHBOARDS_IMPORT_STATS_PREFIX = exports.LEGACY_DASHBOARDS_EXPORT_STATS_PREFIX = exports.IMPORT_STATS_PREFIX = exports.GET_STATS_PREFIX = exports.FIND_STATS_PREFIX = exports.EXPORT_STATS_PREFIX = exports.DELETE_STATS_PREFIX = exports.CoreUsageStatsClient = exports.CREATE_STATS_PREFIX = exports.BULK_UPDATE_STATS_PREFIX = exports.BULK_RESOLVE_STATS_PREFIX = exports.BULK_GET_STATS_PREFIX = exports.BULK_DELETE_STATS_PREFIX = exports.BULK_CREATE_STATS_PREFIX = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _coreUsageDataBaseServerInternal = require("@kbn/core-usage-data-base-server-internal");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const BULK_CREATE_STATS_PREFIX = exports.BULK_CREATE_STATS_PREFIX = 'apiCalls.savedObjectsBulkCreate';
const BULK_GET_STATS_PREFIX = exports.BULK_GET_STATS_PREFIX = 'apiCalls.savedObjectsBulkGet';
const BULK_RESOLVE_STATS_PREFIX = exports.BULK_RESOLVE_STATS_PREFIX = 'apiCalls.savedObjectsBulkResolve';
const BULK_UPDATE_STATS_PREFIX = exports.BULK_UPDATE_STATS_PREFIX = 'apiCalls.savedObjectsBulkUpdate';
const BULK_DELETE_STATS_PREFIX = exports.BULK_DELETE_STATS_PREFIX = 'apiCalls.savedObjectsBulkDelete';
const CREATE_STATS_PREFIX = exports.CREATE_STATS_PREFIX = 'apiCalls.savedObjectsCreate';
const DELETE_STATS_PREFIX = exports.DELETE_STATS_PREFIX = 'apiCalls.savedObjectsDelete';
const FIND_STATS_PREFIX = exports.FIND_STATS_PREFIX = 'apiCalls.savedObjectsFind';
const GET_STATS_PREFIX = exports.GET_STATS_PREFIX = 'apiCalls.savedObjectsGet';
const RESOLVE_STATS_PREFIX = exports.RESOLVE_STATS_PREFIX = 'apiCalls.savedObjectsResolve';
const UPDATE_STATS_PREFIX = exports.UPDATE_STATS_PREFIX = 'apiCalls.savedObjectsUpdate';
const IMPORT_STATS_PREFIX = exports.IMPORT_STATS_PREFIX = 'apiCalls.savedObjectsImport';
const RESOLVE_IMPORT_STATS_PREFIX = exports.RESOLVE_IMPORT_STATS_PREFIX = 'apiCalls.savedObjectsResolveImportErrors';
const EXPORT_STATS_PREFIX = exports.EXPORT_STATS_PREFIX = 'apiCalls.savedObjectsExport';
const LEGACY_DASHBOARDS_IMPORT_STATS_PREFIX = exports.LEGACY_DASHBOARDS_IMPORT_STATS_PREFIX = 'apiCalls.legacyDashboardImport';
const LEGACY_DASHBOARDS_EXPORT_STATS_PREFIX = exports.LEGACY_DASHBOARDS_EXPORT_STATS_PREFIX = 'apiCalls.legacyDashboardExport';
const ALL_COUNTER_FIELDS = [
// Saved Objects Client APIs
...getFieldsForCounter(BULK_CREATE_STATS_PREFIX), ...getFieldsForCounter(BULK_GET_STATS_PREFIX), ...getFieldsForCounter(BULK_RESOLVE_STATS_PREFIX), ...getFieldsForCounter(BULK_UPDATE_STATS_PREFIX), ...getFieldsForCounter(BULK_DELETE_STATS_PREFIX), ...getFieldsForCounter(CREATE_STATS_PREFIX), ...getFieldsForCounter(DELETE_STATS_PREFIX), ...getFieldsForCounter(FIND_STATS_PREFIX), ...getFieldsForCounter(GET_STATS_PREFIX), ...getFieldsForCounter(RESOLVE_STATS_PREFIX), ...getFieldsForCounter(UPDATE_STATS_PREFIX),
// Saved Objects Management APIs
...getFieldsForCounter(IMPORT_STATS_PREFIX), `${IMPORT_STATS_PREFIX}.createNewCopiesEnabled.yes`, `${IMPORT_STATS_PREFIX}.createNewCopiesEnabled.no`, `${IMPORT_STATS_PREFIX}.overwriteEnabled.yes`, `${IMPORT_STATS_PREFIX}.overwriteEnabled.no`, ...getFieldsForCounter(RESOLVE_IMPORT_STATS_PREFIX), `${RESOLVE_IMPORT_STATS_PREFIX}.createNewCopiesEnabled.yes`, `${RESOLVE_IMPORT_STATS_PREFIX}.createNewCopiesEnabled.no`, ...getFieldsForCounter(EXPORT_STATS_PREFIX), ...getFieldsForCounter(LEGACY_DASHBOARDS_IMPORT_STATS_PREFIX), ...getFieldsForCounter(LEGACY_DASHBOARDS_EXPORT_STATS_PREFIX), `${EXPORT_STATS_PREFIX}.allTypesSelected.yes`, `${EXPORT_STATS_PREFIX}.allTypesSelected.no`,
// Saved Objects Repository counters; these are included here for stats collection, but are incremented in the repository itself
_coreUsageDataBaseServerInternal.REPOSITORY_RESOLVE_OUTCOME_STATS.EXACT_MATCH, _coreUsageDataBaseServerInternal.REPOSITORY_RESOLVE_OUTCOME_STATS.ALIAS_MATCH, _coreUsageDataBaseServerInternal.REPOSITORY_RESOLVE_OUTCOME_STATS.CONFLICT, _coreUsageDataBaseServerInternal.REPOSITORY_RESOLVE_OUTCOME_STATS.NOT_FOUND, _coreUsageDataBaseServerInternal.REPOSITORY_RESOLVE_OUTCOME_STATS.TOTAL];
const SPACE_CONTEXT_REGEX = /^\/s\/([a-z0-9_\-]+)/;

// Buffering up to 10k events because:
// - ALL_COUNTER_FIELDS has 125 fields, so that's the max request we can expect after grouping the keys.
// - A typical counter reports 3 fields, so taking 10k events, means around 30k fields (to be later grouped into max 125 fields).
// - Taking into account the longest possible string, this queue can use 15MB max.
const MAX_BUFFER_SIZE = 10_000;
const DEFAULT_BUFFER_TIME_MS = 10_000;

/**
 * Interface that models some of the core events (e.g. SO HTTP API calls)
 * @internal
 */

/** @internal */

/** @internal */
class CoreUsageStatsClient {
  constructor({
    debugLogger,
    basePath,
    repositoryPromise,
    stop$,
    incrementUsageCounter,
    bufferTimeMs = DEFAULT_BUFFER_TIME_MS
  }) {
    (0, _defineProperty2.default)(this, "debugLogger", void 0);
    (0, _defineProperty2.default)(this, "basePath", void 0);
    (0, _defineProperty2.default)(this, "repositoryPromise", void 0);
    (0, _defineProperty2.default)(this, "fieldsToIncrement$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "flush$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "coreUsageEvents$", new _rxjs.Subject());
    this.debugLogger = debugLogger;
    this.basePath = basePath;
    this.repositoryPromise = repositoryPromise;
    this.fieldsToIncrement$.pipe((0, _rxjs.takeUntil)(stop$),
    // Buffer until either the timer, a forced flush occur, or there are too many queued fields
    (0, _rxjs.bufferWhen)(() => (0, _rxjs.merge)((0, _rxjs.interval)(bufferTimeMs), this.flush$, this.fieldsToIncrement$.pipe((0, _rxjs.skip)(MAX_BUFFER_SIZE)))), (0, _rxjs.map)(listOfFields => {
      const fieldsMap = listOfFields.flat().reduce((acc, fieldName) => {
        var _acc$get;
        const incrementCounterField = (_acc$get = acc.get(fieldName)) !== null && _acc$get !== void 0 ? _acc$get : {
          fieldName,
          incrementBy: 0
        };
        incrementCounterField.incrementBy++;
        return acc.set(fieldName, incrementCounterField);
      }, new Map());
      return [...fieldsMap.values()];
    }), (0, _rxjs.filter)(fields => fields.length > 0), (0, _rxjs.exhaustMap)(async fields => {
      const options = {
        refresh: false
      };
      try {
        const repository = await this.repositoryPromise;
        await repository.incrementCounter(_coreUsageDataBaseServerInternal.CORE_USAGE_STATS_TYPE, _coreUsageDataBaseServerInternal.CORE_USAGE_STATS_ID, fields, options);
      } catch (err) {
        // do nothing
      }
    })).subscribe();
    this.coreUsageEvents$.pipe((0, _rxjs.takeUntil)(stop$), (0, _rxjs.tap)(({
      id,
      isKibanaRequest,
      types
    }) => {
      const kibanaYesNo = isKibanaRequest ? 'yes' : 'no';
      // NB this usage counter has the domainId: 'core', and so will related docs in 'kibana-usage-counters' data view
      types === null || types === void 0 ? void 0 : types.forEach(type => incrementUsageCounter({
        counterName: `savedObjects.${id}.kibanaRequest.${kibanaYesNo}.types.${type}`
      }));
    })).subscribe();
  }
  async getUsageStats() {
    this.debugLogger('getUsageStats() called');
    let coreUsageStats = {};
    try {
      const repository = await this.repositoryPromise;
      this.flush$.next();
      const result = await repository.incrementCounter(_coreUsageDataBaseServerInternal.CORE_USAGE_STATS_TYPE, _coreUsageDataBaseServerInternal.CORE_USAGE_STATS_ID, ALL_COUNTER_FIELDS, {
        initialize: true
      } // set all counter fields to 0 if they don't exist
      );
      coreUsageStats = result.attributes;
    } catch (err) {
      // do nothing
    }
    return coreUsageStats;
  }
  async incrementSavedObjectsBulkCreate(options) {
    await this.updateUsageStats([], BULK_CREATE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsBulkGet(options) {
    await this.updateUsageStats([], BULK_GET_STATS_PREFIX, options);
  }
  async incrementSavedObjectsBulkResolve(options) {
    await this.updateUsageStats([], BULK_RESOLVE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsBulkUpdate(options) {
    await this.updateUsageStats([], BULK_UPDATE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsBulkDelete(options) {
    await this.updateUsageStats([], BULK_DELETE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsCreate(options) {
    await this.updateUsageStats([], CREATE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsDelete(options) {
    await this.updateUsageStats([], DELETE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsFind(options) {
    await this.updateUsageStats([], FIND_STATS_PREFIX, options);
  }
  async incrementSavedObjectsGet(options) {
    await this.updateUsageStats([], GET_STATS_PREFIX, options);
  }
  async incrementSavedObjectsResolve(options) {
    await this.updateUsageStats([], RESOLVE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsUpdate(options) {
    await this.updateUsageStats([], UPDATE_STATS_PREFIX, options);
  }
  async incrementSavedObjectsImport(options) {
    const {
      createNewCopies,
      overwrite,
      compatibilityMode
    } = options;
    const counterFieldNames = [`createNewCopiesEnabled.${createNewCopies ? 'yes' : 'no'}`, ...(!createNewCopies ? [`overwriteEnabled.${overwrite ? 'yes' : 'no'}`] : []),
    // the overwrite option is ignored when createNewCopies is true
    ...(!createNewCopies ? [`compatibilityModeEnabled.${compatibilityMode ? 'yes' : 'no'}`] : []) // the compatibilityMode option is ignored when createNewCopies is true
    ];
    await this.updateUsageStats(counterFieldNames, IMPORT_STATS_PREFIX, options);
  }
  async incrementSavedObjectsResolveImportErrors(options) {
    const {
      createNewCopies,
      compatibilityMode
    } = options;
    const counterFieldNames = [`createNewCopiesEnabled.${createNewCopies ? 'yes' : 'no'}`, ...(!createNewCopies ? [`compatibilityModeEnabled.${compatibilityMode ? 'yes' : 'no'}`] : []) // the compatibilityMode option is ignored when createNewCopies is true
    ];
    await this.updateUsageStats(counterFieldNames, RESOLVE_IMPORT_STATS_PREFIX, options);
  }
  async incrementSavedObjectsExport(options) {
    const {
      types,
      supportedTypes
    } = options;
    const isAllTypesSelected = !!types && supportedTypes.every(x => types.includes(x));
    const counterFieldNames = [`allTypesSelected.${isAllTypesSelected ? 'yes' : 'no'}`];
    await this.updateUsageStats(counterFieldNames, EXPORT_STATS_PREFIX, options);
  }
  async incrementLegacyDashboardsImport(options) {
    await this.updateUsageStats([], LEGACY_DASHBOARDS_IMPORT_STATS_PREFIX, options);
  }
  async incrementLegacyDashboardsExport(options) {
    await this.updateUsageStats([], LEGACY_DASHBOARDS_EXPORT_STATS_PREFIX, options);
  }
  async updateUsageStats(counterFieldNames, id, {
    request,
    types
  }) {
    const isKibanaRequest = getIsKibanaRequest(request);
    const spaceId = this.getNamespace(request);
    const fields = this.getFieldsToIncrement({
      counterFieldNames,
      prefix: id,
      isKibanaRequest,
      spaceId
    });
    this.coreUsageEvents$.next({
      id,
      isKibanaRequest,
      types
    });
    this.fieldsToIncrement$.next(fields);
  }
  getNamespace(request) {
    const requestBasePath = this.basePath.get(request); // obtain the original request basePath, as it may have been modified by a request interceptor
    const pathToCheck = this.basePath.remove(requestBasePath); // remove the server basePath from the request basePath
    const matchResult = pathToCheck.match(SPACE_CONTEXT_REGEX); // Look for `/s/space-url-context` in the base path

    if (!matchResult || matchResult.length === 0) {
      return _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
    }

    // Ignoring first result, we only want the capture group result at index 1
    return matchResult[1];
  }
  getFieldsToIncrement({
    prefix,
    counterFieldNames,
    spaceId,
    isKibanaRequest
  }) {
    const namespaceField = spaceId === _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING ? 'default' : 'custom';
    return ['total', `namespace.${namespaceField}.total`, `namespace.${namespaceField}.kibanaRequest.${isKibanaRequest ? 'yes' : 'no'}`, ...counterFieldNames].map(x => `${prefix}.${x}`);
  }
}
exports.CoreUsageStatsClient = CoreUsageStatsClient;
function getFieldsForCounter(prefix) {
  return ['total', 'namespace.default.total', 'namespace.default.kibanaRequest.yes', 'namespace.default.kibanaRequest.no', 'namespace.custom.total', 'namespace.custom.kibanaRequest.yes', 'namespace.custom.kibanaRequest.no'].map(x => `${prefix}.${x}`);
}
function getIsKibanaRequest({
  headers
}) {
  // The presence of these request headers gives us a good indication that this is a first-party request from the Kibana client.
  // We can't be 100% certain, but this is a reasonable attempt.
  return Boolean(headers && headers['kbn-version'] && headers.referer && headers['x-elastic-internal-origin']);
}