"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMEZONE_OPTIONS = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TIMEZONE_OPTIONS = exports.TIMEZONE_OPTIONS = [..._momentTimezone.default.tz.names()
// We need to filter out some time zones, that moment.js knows about, but Elasticsearch
// does not understand and would fail thus with a 400 bad request when using them.
.filter(tz => !['America/Nuuk', 'EST', 'HST', 'ROC', 'MST'].includes(tz))];