"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForDeleteByQueryTask = void 0;
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var Option = _interopRequireWildcard(require("fp-ts/lib/Option"));
var _function = require("fp-ts/lib/function");
var _wait_for_task = require("./wait_for_task");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

const waitForDeleteByQueryTask = exports.waitForDeleteByQueryTask = (0, _function.flow)(_wait_for_task.waitForTask, TaskEither.chainW(res => {
  var _res$response;
  if (Option.isSome(res.failures) || (_res$response = res.response) !== null && _res$response !== void 0 && _res$response.version_conflicts) {
    var _res$response2;
    return TaskEither.left({
      type: 'cleanup_failed',
      failures: Option.isSome(res.failures) ? res.failures.value : [],
      versionConflicts: (_res$response2 = res.response) === null || _res$response2 === void 0 ? void 0 : _res$response2.version_conflicts
    });
  } else if (Option.isSome(res.error)) {
    throw new Error('waitForDeleteByQueryTask task failed with the following error:\n' + JSON.stringify(res.error.value));
  } else {
    var _res$response3;
    return TaskEither.right({
      type: 'cleanup_successful',
      deleted: (_res$response3 = res.response) === null || _res$response3 === void 0 ? void 0 : _res$response3.deleted
    });
  }
}));