"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAndPickupMappings = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var _pipeable = require("fp-ts/lib/pipeable");
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
var _pickup_updated_mappings = require("./pickup_updated_mappings");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

/**
 * Updates an index's mappings and runs an pickupUpdatedMappings task so that the mapping
 * changes are "picked up". Returns a taskId to track progress.
 */
const updateAndPickupMappings = ({
  client,
  index,
  mappings,
  batchSize,
  query
}) => {
  const putMappingTask = () => {
    return client.indices.putMapping({
      index,
      timeout: _constants.DEFAULT_TIMEOUT,
      ...mappings
    }).then(() => {
      // Ignore `acknowledged: false`. When the coordinating node accepts
      // the new cluster state update but not all nodes have applied the
      // update within the timeout `acknowledged` will be false. However,
      // retrying this update will always immediately result in `acknowledged:
      // true` even if there are still nodes which are falling behind with
      // cluster state updates.
      // For updateAndPickupMappings this means that there is the potential
      // that some existing document's fields won't be picked up if the node
      // on which the Kibana shard is running has fallen behind with cluster
      // state updates and the mapping update wasn't applied before we run
      // `pickupUpdatedMappings`. ES tries to limit this risk by blocking
      // index operations (including update_by_query used by
      // updateAndPickupMappings) if there are pending mappings changes. But
      // not all mapping changes will prevent this.
      return Either.right('update_mappings_succeeded');
    }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
  };
  return (0, _pipeable.pipe)(putMappingTask, TaskEither.chain(res => {
    return (0, _pickup_updated_mappings.pickupUpdatedMappings)(client, index, batchSize, query);
  }));
};
exports.updateAndPickupMappings = updateAndPickupMappings;