"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initAction = exports.checkClusterRoutingAllocationEnabledTask = void 0;
var TaskEither = _interopRequireWildcard(require("fp-ts/lib/TaskEither"));
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _pipeable = require("fp-ts/lib/pipeable");
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
var _fetch_indices = require("./fetch_indices");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const routingAllocationEnable = 'cluster.routing.allocation.enable';
const checkClusterRoutingAllocationEnabledTask = ({
  client
}) => () => {
  return client.cluster.getSettings({
    flat_settings: true
  }).then(settings => {
    var _settings$transient$r, _settings$transient, _settings$persistent;
    // transient settings take preference over persistent settings
    const clusterRoutingAllocation = (_settings$transient$r = settings === null || settings === void 0 ? void 0 : (_settings$transient = settings.transient) === null || _settings$transient === void 0 ? void 0 : _settings$transient[routingAllocationEnable]) !== null && _settings$transient$r !== void 0 ? _settings$transient$r : settings === null || settings === void 0 ? void 0 : (_settings$persistent = settings.persistent) === null || _settings$persistent === void 0 ? void 0 : _settings$persistent[routingAllocationEnable];
    const clusterRoutingAllocationEnabledIsAll = clusterRoutingAllocation === undefined || clusterRoutingAllocation === 'all';
    if (!clusterRoutingAllocationEnabledIsAll) {
      return Either.left({
        type: 'incompatible_cluster_routing_allocation'
      });
    } else {
      return Either.right({});
    }
  }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
exports.checkClusterRoutingAllocationEnabledTask = checkClusterRoutingAllocationEnabledTask;
const initAction = ({
  client,
  indices
}) => {
  return (0, _pipeable.pipe)(checkClusterRoutingAllocationEnabledTask({
    client
  }), TaskEither.chainW(value => {
    return (0, _fetch_indices.fetchIndices)({
      client,
      indices
    });
  }));
};
exports.initAction = initAction;