"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticAssets = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/**
 * Convention is for trailing slashes in pathnames are stripped.
 */
class StaticAssets {
  constructor({
    basePath,
    cdnConfig,
    shaDigest
  }) {
    (0, _defineProperty2.default)(this, "assetsHrefBase", void 0);
    (0, _defineProperty2.default)(this, "assetsServerPathBase", void 0);
    (0, _defineProperty2.default)(this, "hasCdnHost", void 0);
    const cdnBaseHref = cdnConfig.baseHref;
    if (cdnBaseHref) {
      this.hasCdnHost = true;
      this.assetsHrefBase = (0, _util.suffixPathnameToURLPathname)(cdnBaseHref, shaDigest);
    } else {
      this.hasCdnHost = false;
      this.assetsHrefBase = (0, _util.suffixPathnameToPathname)(basePath.serverBasePath, shaDigest);
    }
    this.assetsServerPathBase = `/${shaDigest}`;
  }

  /**
   * Returns a href (hypertext reference) intended to be used as the base for constructing
   * other hrefs to static assets.
   */
  getHrefBase() {
    return this.assetsHrefBase;
  }
  getPluginAssetHref(pluginName, assetPath) {
    if (assetPath.startsWith('/')) {
      assetPath = assetPath.slice(1);
    }
    return `${this.assetsHrefBase}/plugins/${pluginName}/assets/${(0, _util.removeSurroundingSlashes)(assetPath)}`;
  }
  prependServerPath(path) {
    return `${this.assetsServerPathBase}/${(0, _util.removeSurroundingSlashes)(path)}`;
  }
  prependPublicUrl(pathname) {
    if (this.hasCdnHost) {
      return (0, _util.suffixPathnameToURLPathname)(this.assetsHrefBase, pathname);
    }
    return (0, _util.suffixPathnameToPathname)(this.assetsHrefBase, pathname);
  }
  getPluginServerPath(pluginName, assetPath) {
    return `${this.assetsServerPathBase}/plugins/${pluginName}/assets/${(0, _util.removeSurroundingSlashes)(assetPath)}`;
  }
}
exports.StaticAssets = StaticAssets;